//Authors: S.Venkatesan, Sandeep Kumar Shukla and Yuvaraj Rajendra
package euser
import (
		"time"
		"math/rand"
		"variables"
		//"fmt"
	)

func Scorecompute(votee int, messageid int, votevalue int, votetype int, tmodel int, voter int, incentiveentry int, messagestatus int) {
	var score[vars.Nf] func(int, int, int, int, int, int, int, int, int)
	//decen(votee, messageid, votevalue, votetype, 0, tmodel, voter, incentiveentry)
	//inside(votee, messageid, votevalue, votetype, 1, tmodel)
	score[0] = func(votee int, messageid int, votevalue int, votetype int, entry int, tmodel int, voter int, incentiveentry int, messagestatus int) {
			// for none model
		   }
	score[1] = func(votee int, messageid int, votevalue int, votetype int, entry int, tmodel int, voter int, incentiveentry int, messagestatus int) { // for decentralized model
				output := 0
				vars.Oscillation[1] = float64(vars.Totalnodes/2) //oscillation threshold
				if votetype == 2 {

				} else {
					if votevalue == 0 {
						//output = decentfactcompute(messageid, tmodel)
						output = Decisioncallfact(votee, tmodel, messageid, voter, messagestatus)
						if output == -1 {
							vars.Tscore[tmodel][votee][0] = 0
							if vars.Nodeactive[votee][1] != votee && vars.Nodeactive[votee][3] != 1 {
								tempir := vars.Nodeactive[votee][1]
								vars.Tscore[tmodel][tempir][5] = vars.Tscore[tmodel][vars.Nodeactive[votee][1]][5] - float64(1) // reduce the introducer count
								vars.Tscore[tmodel][tempir][0] = vars.Tscore[tmodel][tempir][1] + vars.Tscore[tmodel][tempir][2] + vars.Tscore[tmodel][tempir][3] + vars.Tscore[tmodel][tempir][4] + vars.Tscore[tmodel][tempir][5] 
								vars.Nodeactive[votee][3] = 1
							}
							vars.Tscore[tmodel][voter][incentiveentry] = vars.Tscore[tmodel][voter][incentiveentry] + float64(1) // votee count

						} else {
							// may ne negative vote added
						}
					} else 	{
						if votee != voter {
							if vars.Nodeactive[voter][5] == 1 { 
								vars.Tscore[tmodel][votee][4] = vars.Tscore[tmodel][votee][4] + float64(votevalue) //in 4th index for private vote value.
							}  else {
								vars.Tscore[tmodel][votee][6] = vars.Tscore[tmodel][votee][6] + float64(votevalue) //in 4th index for public vote value.
							}
						}
						vars.Tscore[tmodel][voter][incentiveentry] = vars.Tscore[tmodel][voter][incentiveentry] + float64(1) // votee count
					}
					vars.Tscore[tmodel][votee][0] = vars.Tscore[tmodel][votee][1] + vars.Tscore[tmodel][votee][2] + vars.Tscore[tmodel][votee][3] + vars.Tscore[tmodel][votee][4] + vars.Tscore[tmodel][votee][5] + vars.Tscore[tmodel][votee][6]
					vars.Tscore[tmodel][voter][0] = vars.Tscore[tmodel][voter][1] + vars.Tscore[tmodel][voter][2] + vars.Tscore[tmodel][voter][3] + vars.Tscore[tmodel][voter][4] + vars.Tscore[tmodel][voter][5] + vars.Tscore[tmodel][votee][6]
					if output == -1 {
						vars.Tscore[tmodel][votee][0] = float64(0)
					}
				}
			}
	score[2] = func(votee int, messageid int, votevalue int, votetype int, entry int, tmodel int, voter int, incentiveentry int, messagestatus int) { // for insider model
			positive := 0
			negative := 0
			if votetype == 2 { // refers incentive
		
			} else {
				for i := 1; i <= vars.N * vars.N; i++ {
					if vars.Tcompute[tmodel][votee][i][0] != -1  {
						if vars.Tcompute[tmodel][votee][i][0] == 0 {
							negative = negative + 1
						} else if vars.Tcompute[tmodel][votee][i][0] == 1 {
							positive = positive + 1
						}
					}
				}
				vars.Tscore[tmodel][votee][0] = (float64(positive) - float64(negative))/(float64(positive) + float64(negative))
				//fmt.Println(vars.Tscore[tmodel][votee][0])
				//vars.Tscore[tmodel][votee][0] = vars.Tscore[tmodel][votee][0] + vars.Tscore[tmodel][votee][1] 
			}
		}

	score[3] = func(votee int, messageid int, votevalue int, votetype int, entry int, tmodel int, voter int, incentiveentry int, messagestatus int) { // for tnasl model
			positive := 0
			negative := 0
			if votetype == 2 { // refers incentive
		
			} else {
				for i := 1; i <= vars.N * vars.N; i++ {
					if vars.Tcompute[tmodel][votee][i][0] != -1  {
						if vars.Tcompute[tmodel][votee][i][0] == 0 {
							negative = negative + 1
						} else if vars.Tcompute[tmodel][votee][i][0] == 1 {
							positive = positive + 1
						}
					}
				}
				vars.Tscore[tmodel][votee][1] = float64(positive)/(float64(positive) + float64(negative) + float64(2))
				vars.Tscore[tmodel][votee][2] = float64(negative)/(float64(positive) + float64(negative) + float64(2))
				vars.Tscore[tmodel][votee][3] = float64(2.0)/(float64(positive) + float64(negative) + float64(2))
				//vars.Tscore[tmodel][votee][0] = 
				value := float64(0)
				if vars.Nodeactive[votee][5] == 1 {
					value = float64(1)
				} else {
					value = float64(0.5)
				}
				vars.Tscore[tmodel][votee][0] = vars.Tscore[tmodel][votee][1] + vars.Tscore[tmodel][votee][2] + vars.Tscore[tmodel][votee][3] +  value
			}
		}


	if tmodel <= 3 { // this has to be increased if any new model is introduced and this function is used for that model
		score[tmodel](votee, messageid, votevalue, votetype, 0, tmodel, voter, incentiveentry, messagestatus)
		//score[2](votee, messageid, votevalue, votetype, 0, tmodel, voter, incentiveentry)
	}
}

// this function is for giving negative vote for the nodes based on the votes available in the fact table.
func Factvotecompute(tmodel int) {
	var factvotecompute[vars.Nf] func(int)
        factvotecompute[0] = func(tmodel int) {
			     }
	factvotecompute[1] = func(tmodel int) {
			     }
	factvotecompute[2] = func(tmodel int) {
		for i := 0; i < vars.Fe; i++ {
                	if vars.Fact1[i][0] == 2 && vars.Fact1[i][4] == vars.Presentsession { // this refers for the voting
                        	factscore := float64(vars.Fact1[i][9])/float64(vars.Fact1[i][10])
				fthreshold := float64(2)
                           	if factscore >= fthreshold {
                                	vars.Tscore[tmodel][vars.Fact1[i][8]][2] = vars.Tscore[tmodel][vars.Fact1[i][8]][2] + float64(1)
                           	}
                	}
        	}
	}
        if tmodel <= 2 { // this has to be increased if any new model is introduced and this function is used for that model
		factvotecompute[tmodel](tmodel)
	}
}




//this function is to find the score of a node and return for whitewhashing decision
func Nodescore(nodei int, tmodel int) float64 {
	var nodescore[vars.Nf] func(int, int) float64
        nodescore[0] = func(nodei int, f int) float64 {  //none
                        return 1        // always accept
                      }
        nodescore[1] = func(nodei int, f int) float64 {  //decentralized
                        return vars.Tscore[f][nodei][0] 
                       }
        nodescore[2] = func(nodei int, f int) float64 { // insider
                        return vars.Tscore[f][nodei][0] - float64(vars.Tscore[f][nodei][1] + vars.Tscore[f][nodei][2])
        		}
	nodescore[3] = func(nodei int, f int) float64 { // tnasl
                        return vars.Tscore[f][nodei][0]
                      }
        nscore := float64(0)
	if tmodel <= 3 { // this has to be increased if any new model is introduced and this function is used for that model
        	nscore = nodescore[tmodel](nodei, tmodel)
        }
	return nscore
}

//this function is to clean the score to perform whitewashing 
func Scoreclean(nodei int, tmodel int) {
	var scoreclean[vars.Nf] func(int, int) 
        scoreclean[0] = func(nodei int, f int) {  //none
                                // always accept
                      }
        scoreclean[1] = func(nodei int, f int) {  //decentralized
                        vars.Tscore[f][nodei][0] = 0 
                        vars.Tscore[f][nodei][1] = 0 
                        vars.Tscore[f][nodei][2] = 0 
                        vars.Tscore[f][nodei][3] = 0 
                        vars.Tscore[f][nodei][4] = 0 
                        vars.Tscore[f][nodei][5] = 0 
                       }
        scoreclean[2] = func(nodei int, f int) { // insider
                        vars.Tscore[f][nodei][0] = 0
			vars.Tscore[f][nodei][1] = 0
			vars.Tscore[f][nodei][2] = 0
        		}
	 scoreclean[3] = func(nodei int, f int) { // tnasl
                        vars.Tscore[f][nodei][0] = 0
			vars.Tscore[f][nodei][1] = 0
			vars.Tscore[f][nodei][2] = 0
			vars.Tscore[f][nodei][3] = 0
                      }
        if tmodel <= 3 { // this has to be increased if any new model is introduced and this function is used for that model
		scoreclean[tmodel](nodei, tmodel)
	}
}

//this function is to re-initialize the score on next session 
func Scorereinitialize() {
	var reinitialize[vars.Nf] func(int, int) 
        reinitialize[0] = func(nodei int, f int) {  //none
                                // always accept
                      }
        reinitialize[1] = func(nodei int, f int)  {  //decentralized
                      }
        reinitialize[2] = func(nodei int, f int)  { // insider
                      vars.Tscore[f][nodei][1] = (vars.Tscore[f][nodei][1] * 0.5) + vars.Tscore[f][nodei][2] // past session - for history
                      vars.Tscore[f][nodei][2] = 0 // clearing the attack history for the present session
                      vars.Tscore[f][nodei][0] = 0 // clearing the score for the present session
		      }
        for fu := 0; fu < vars.Nf; fu++ {
                for i := 1; i < vars.Nodesize;  i++ {
        		if fu <= 2 { // this has to be increased if any new model is introduced and this function is used for that model
				reinitialize[fu](i, fu)
			}
                }
        }
}

//this function helps to checke the reputation of a node before it introduces another new node
func Decisionintroduce(nodei int, tmodel int, sender int) int {  // tmodel is integer identity of the trust model
	accept := 0
/*	if f == 0 {
		accept = 1
	}else if f == 1 {
		accept = decent(nodei, f, sender)
	} else if f == 2 {
		accept = insider(nodei, f, sender)
	}
	return accept
}*/
	var decision[vars.Nf] func(int, int, int) int
	decision[0] = func(nodei int, f int, sender int) int {  //none
			return 1	// always accept
		      }
	decision[1] = func(nodei int, f int, sender int) int {  //decentralized
			accept := 0
			threshold := float64(vars.Totalnodes/2) //computing the threshold
			if vars.Tscore[f][sender][0] > threshold { //need to be updated according to the history
				accept = 1
			}
			return accept
		       }
	decision[2] = func(nodei int, f int, sender int) int { // insider
			return 1
		      }
        if tmodel <= 2 { // this has to be increased if any new model is introduced and this function is used for that model
		accept = decision[tmodel](nodei, tmodel, sender)
	}
	return accept
}



func Decisioncall(nodei int, tmodel int, sender int) int {  // tmodel is integer identity of the trust model
	accept := 0
/*	if f == 0 {
		accept = 1
	}else if f == 1 {
		accept = decent(nodei, f, sender)
	} else if f == 2 {
		accept = insider(nodei, f, sender)
	}
	return accept
}*/
	var decision[vars.Nf] func(int, int, int) int
	decision[0] = func(nodei int, f int, sender int) int {  //none
			return 1	// always accept
		      }
	decision[1] = func(nodei int, f int, sender int) int {  //decentralized
			accept := 0
			threshold := float64(vars.Totalnodes/2) //computing the threshold
			if vars.Tscore[f][sender][0] > threshold { //need to be updated according to the history
				total := float64(vars.Tscore[f][sender][4] + vars.Tscore[f][sender][6])
				if total >= float64((vars.Tscore[f][sender][0]/float64(10)) * float64(4)) {
					if vars.Tscore[f][sender][4] >= float64(total/float64(10) * float64(2.5)) {
						accept = 1
					}
				}
			}
			return accept
		       }
	decision[2] = func(nodei int, f int, sender int) int { // insider
			accept := 0
			athreshold := float64(0.4)
			rthreshold := float64(-0.4)
			score := vars.Tscore[f][sender][0] - (vars.Tscore[f][sender][1] + vars.Tscore[f][sender][2])
			if score >= athreshold { //need to be updated according to the history
				accept = 1
				//fmt.Println("check",vars.Tscore[f][sender][0])

			} else if score <= rthreshold { //need to be updated according to the history
				accept = 2 // 2 refers attacker
			} else {
				rand.Seed(time.Now().UnixNano())
				accept1 := rand.Intn(50)
				if accept1 == 1 {
					//fmt.Println("echo")
					accept = 1
				} else {
					accept = 0
				}
			}
			//fmt.Println(sender, score, accept)
			return accept
		      }
	decision[3] = func(nodei int, f int, sender int) int { // tnasl
		  	accept := 0
			threshold := float64(0.5)
			if vars.Tscore[f][sender][0] >= threshold {
				accept = 1
			}	
			return accept
		      }
        if tmodel <= 3 { // this has to be increased if any new model is introduced and this function is used for that model
		accept = decision[tmodel](nodei, tmodel, sender)
	}
	return accept
}

// call the function run the respective fact function
func Decisioncallresponse(nodei int, tmodel int, messageid int, messagestatus int, sender int) int {
        output := 0
	/*if f == 0 {
		return 1
	} else if  f == 1 {
                output = decentresponsecompute(nodei, messageid )
        } else if f == 2 {
                output = insiderresponsecompute(nodei, messageid, sender, f)
        }
        return output*/
	var decisionresponse[vars.Nf] func(int, int, int, int, int) int
	decisionresponse[0] = func(nodei int, messageid int, messagestatus int, sender int, tmodel int) int { //decision response for none
			      	return 1
			      }
	decisionresponse[1] = func(nodei int, messageid int, messagestatus int, sender int, tmodel int) int { //decision response for decentralized
				var responsecount[vars.Nsvarraysize] int
				var status int
				var total int
				var responsescore float64
				for i := 0; i < vars.Nsv[messageid]; i++ {
					responsecount[i] = 0
				}
				for i := 0; i < vars.Nentry; i++ {
					if  vars.Nodemain[nodei][i][5] == messageid && vars.Nodemain[nodei][i][0] == 2 && vars.Nodemain[nodei][i][9] != -1 && vars.Nodemain[nodei][i][1] != 1  {
						status = vars.Nodemain[nodei][i][7] //check this whether it is 6 or 7	
						responsecount[status] ++
						total ++
					}
				}
				if total > 0 {
					//responsescore = float64(responsecount[messageid]/total)
					responsescore = float64(responsecount[messagestatus]/total)
					fthreshold := float64(0.66)
					athreshold := float64(0.33)
					if responsescore >= fthreshold {
						return 1
					} else if responsescore < athreshold {
						return -1
					} else {
						return 0
					}
				}
				return 0

			       }
	decisionresponse[2] = func(nodei int, messageid int, messagestatus int, sender int, tmodel int) int { //decision response for insider
		        	var responsecount[vars.Nsvarraysize] int
				var status int
				var total int
				var responsescore float64
				for i := 0; i < vars.Nsv[messageid]; i++ {
					responsecount[i] = 0
				}
				for i := 0; i < vars.Nentry; i++ {
					if  vars.Nodemain[nodei][i][5] == messageid && vars.Nodemain[nodei][i][0] == 2 && vars.Nodemain[nodei][i][9] != -1 && vars.Nodemain[nodei][i][1] != 1  {
						status = vars.Nodemain[nodei][i][7]	
						responsecount[status] ++
						total ++
					}
				}
				if total > 0 {
					responsescore = float64(responsecount[messagestatus]/total)
					//responsescore = float64(responsecount[messageid]/total)
					
					fthreshold := float64(0.66)
					athreshold := float64(0.33)
					if responsescore >= fthreshold {
						return 1
					} else if responsescore < athreshold {
						return -1
					} else {
						return 0
					}
				}
				return 0
			      }

        if tmodel <= 2 { // this has to be increased if any new model is introduced and this function is used for that model
		output = decisionresponse[tmodel](nodei, messageid, messagestatus, sender, tmodel)
        }
	return output
}


// call the function to run the respective fact function
func Decisioncallfact(nodei int, tmodel int, messageid int, sender int, messagestatus int) int {
        output := 0
	/*if f == 0 {
		return 1
	}else if  f ==1 {
                output = decentfactcompute(messageid)
        } else if f == 2 {
                output = insiderfactcompute(messageid, f, sender)
        }
        return output
}*/
	var decisionfact[vars.Nf] func(int, int, int, int) int
	decisionfact[0] = func(messageid int, tmodel int, sender int, messagestatus int) int {  // for none model
				return 1
			  } 
	decisionfact[1] = func(messageid int, tmodel int, sender int, messagestatus int) int {  // for decentralized
				var fcount[vars.Nsvarraysize] int
				var status int
				var total int
				var factscore float64
				for i := 0; i < vars.Nsv[messageid]; i++ {
					fcount[i] = 0
				}
				for i := 0; i < vars.Fsize; i++ {
					//fmt.Println("facts--------",messageid,vars.Fact1[i][1],vars.Fact1[i][5])
					if vars.Fact1[i][2] == messageid && vars.Fact1[i][4] == vars.Presentsession {
						status = vars.Fact1[i][6]	
						fcount[status] ++
						total ++
					}
				}
				if total > 0 {
					factscore = float64(fcount[messagestatus]/total)
					fthreshold := float64(0.66)
					athreshold := float64(0.33)
					if factscore > fthreshold {
						return 1
					} else if factscore < athreshold {
						return -1
					} else {
						return 0
					}
				}
				return 0
			      }

//function to compute the fact of insider 
	decisionfact[2] = func(messageid int, tmodel int, sender int, messagestatus int) int { // for insider
				//var fcount[vars.Nsvarraysize] int
				//var status int
				//var total int
				//var factscore float64
				//for i := 0; i < vars.Nsv[messageid]; i++ {
				//	fcount[i] = 0
				//}
				for i := 0; i < vars.Fsize; i++ {
					if vars.Fact1[i][2] == messageid && vars.Fact1[i][4] == vars.Presentsession {
						if float64(vars.Fact1[i][9]/vars.Fact1[i][10]) >= float64(2) {
							vars.Tscore[tmodel][sender][2] = vars.Tscore[tmodel][sender][2] + float64(1)
							break
						}
					}
				}
				/*for i := 0; i < vars.Fsize; i++ {
					//fmt.Println("facts--------",messageid,vars.Fact1[i][1],vars.Fact1[i][5])
					if vars.Fact1[i][2] == messageid && vars.Fact1[i][4] == vars.Presentsession {
						status = vars.Fact1[i][6]	
						fcount[status] ++
						total ++
					}
				}
				if total > 0 {
					factscore = float64(fcount[messageid]/total)
					if factscore > 0.5 {
						return 1
					} else if factscore < 0.3 {
						vars.Tscore[tmodel][sender][2] = vars.Tscore[tmodel][sender][2] + 1 
						return -1
					} else {
						return 0
					}
				}*/
				return 3
			      }

        if tmodel <= 2 { // this has to be increased if any new model is introduced and this function is used for that model
		output = decisionfact[tmodel](messageid, tmodel, sender, messagestatus)
	}
	return output
}
