//Authors: S.Venkatesan, Sandeep Kumar Shukla and Yuvaraj Rajendra
package vars
import (
		"time"
	)


// Part 1 - Adjust the values according to requirement.
const N = 200 //N - number of nodes in the simulation - Dont exceed 200
const Sn = 0 // Sn - No of Sybil Nodes
const Dn = 0  // dn - no of disguised nodes
const Mn = 0 // mn - no of malicious node
const Osn = 0 // osn - Number of oscillation node
const Collude = 0 // colluded - is for enabling the colluded attack. 0 - no collusion; 1- collusion
const Colnode = 0 // colnode - Number of collusion noded. This has to be less than the number of malicious node.
const Mnei = 5  // nei - minimum neighbors - minimum 2
const Activities = 1000  // activities - Maximum number of activities to be performed
const Def = 1 // def - duplicate entry in fact table by a node; 0 - no duplicate and 1 - duplicate
const Threshold = 0.5 // threshold you want to set for acceptance of score
const Nos = 1 // Number of session you want to run
const Nra = 1 // nra - node response considered for accepting the message; 0 - no response permitted, 1- permitted 
const Nloc = 1 //nloc - applicability of the node location and attacker on the same location; 0-no need of node location and 1 for node location as well as same location neighbor intially (later it will change) and 2 for sybil attackers node in the same location as well as includes option 1; 3 is for location required as well as sybil attacker in the same location (no need of same location neighbor) 
const Numloc = 4 // numloc - this to tell number of loations and it will be assigned from 0,1,2,... 
const Sta = 1 //sta - no. of service table attributes
const Na = 13 //na - node (main table) attribute
const Nae = 0 //nae - Number of node (main table) additional attribute
const Mi = 6 //mi - node message services or number of message services
const Nsa = 6 //nsa - node service attribute
const Fa = 12 //fa - Number of default fact attribute
const Fae = 0 //fae - number of fact table's additional attribute
const Tsa = 2 //tsa - trust score attribute
const Tsae = 5 //tsae - additional trust score attribute
const Sca = 4 //sca - Number of score computation attribute
const Scae = 0 //scae - Number of additional score computation attribute
const Fec = 1//fec - maximum entry for a node allowed in fact table - 0 (no limit), 1(limit)
const Fe = 2//fe - maximum entry for a node allowed in fact table
const Ne = 2 //ne multiples of total nodes to find number of entries for each node in activity table  
const Nf = 4 //nf - number of trust model going to be evaluated  
const Fsize = 1000 // fsize - fact table size that is maximum entry allowed.
const Vtype = 2 // vtype - number of vote type --> -1 - negative, 1 - positive, 0 - neutral and 2 or more are for incentive
const Nonodegroup = 2 // This refers the number of node group like private and public
const Colludeentry = 100 //colludeentry-This refers the number of entries in the collude array table.
const Updateresourc = 1 // updateresourc is to indicate whether you want ot update the resource on the fly or not; (1) want to update and (0) no update
const Sybilentry = 100 //sybilentry - This refers the number of entries in the sybil array table.
const Maxflynode = 20 // maxflynode - this is to refer the number of on the fly nodes.  
const Eachsessionfly = 1 // eachsessionfly - refers we want to introduce maxflynodes in each session. This should be equal to no of sessions or 1.
const Bsm = 1 // bsm - is for enabling the ballot stuffing and bad mouthing. 0 - no ballot stuffing and bad mouthing; 1- ballot stuffing and bad mouthing
const Nsvarraysize = 6 // nsvarraysize - is that how many different values in nsv array


//Part 2 - Adjust the variables according to the different Models
var Vvalue = [] int{1,1,1,1}  // Number of possible values for each positive vote in the trust models.If it is 2 that means possible values are 1 and 2
var Nvalue = [] int{0,0,0,0}  // Number of Negative values for each positive vote in the trust models. If it is 2 that means possible values are -1 and 0 
var Factventry = []int {0,0,1,0} //factventry - This is to indicate whether the trust model go for claiming a negative message received, identified by itself and prove through global voting
var Resourceupdate = []int {1,1,1,1} //responseupdate - This is to update the service table entry after all set 1 trust model accept the message.--------------------
var Addincentive = []int {0,1,0,0} //addincentive - to include the additional incentives. The number of values are based on the number of functions.
var Addincentvalue = [][]int {{0,0,0,0},{1,1,1,1},{0,0,0,0},{0,0,0,0}} //addincentvalue - to include the incentive values for each activity.; 1 - voter, 2 - block, 3 - fact, 4 - positive vote
var Maxvote = []int {1,1,1,1} //maxvote - maximum vote allowed for each user for the trusted model
var Whitewash = []int {0,0,1,0} //whitewash - this is to mention whether the trust model want the malicious user to go for the whitewash or change his identity
var Whitethreshold = []float64 {0.0,0.0,-0.4,0.0} // whitethreshold is the value that indicates the node as attacker
var Oscillation = []float64 {0.0,0.0,0.4,0.5} // oscillation - this holds the threshold to support the oscillation node to change its behavior after gaining the trust or reputation score. 
var Introduceincentive = []int {0,1,0,0} //incentive - incentive allowed or not; 0 - no incentive, 1- incentive; for each function 
var Introduceincentvalue = []int {0,1,0,0} //incentive - incentive allowed or not; 0 - no incentive, 1- incentive; for each function.
var Introducecond = []int {0,0,0,0} //introducecond - if a trust model want to introduce a new node based on condition then set to 1 otherwise 0.
var Sessionapplicable = []int {0,0,0,0} //sessionapplicability - This is to indicate the session for each trust model; 0 - no session, 1- session; for each function.
var Maxincentive = []int {0,101,101,0} //maxincentive - maximum incentive allowed for each user trust function 
var Blockincentive = [] int {0,1,0,0} //blockincentive - is there facility for the block mining incentive or not; this can be used for other types of incentives; 0 for incentive and 1 for no incentive.
var Blockincentvalue = [] int {0,2,0,0} //blockincentive - is there facility for the block mining incentive or not that is the value for the incentive. If block mining there but no incentive then we can put 0 for that function; this can be used for other types of incentives.
var Factincentive = [] int {0,1,1,0} //factincentive - this is to refer the possibility of fact table in the model. 0 for fact possible as well as incentive and 1 for no incentive..
var Factincentvalue = [] int {0,1,0,0} //factincentvalue - is there facility for the fact incentive or not. If value for factincentive then give that otherwise it can be zero;.
var Ontheflynode = [] int {0,0,0,0} // ontheflynode - this is to introduce the new nodes while running.
var Nsv = []int {5,5,5,5,4,2} //nsv - node service value; for example, if message service or id (mi) is traffic then nsv 0 refers no traffic; 1 refers traffic; 2 may refer too much traffic,..

//Part 3 - Variable Computation
var Sybilindex int //sybilindex - is for maintaining the track of entry in the sybil array
var Colludeindex int //colludeindex - is for maintaining the track of entry in the collude array
var Nentry = N * Ne // Nentry - Number of entries for each node in the nodemain table
var Colluderbloom[Colnode+1][3][Colludeentry] int // colluderbloom is to stop more than one time voting in colluder mode; two is given zero for send message and one for fact
var Sybilbloom[Sn+1][3][Colludeentry] int // sybilbloom is to stop more than one time voting in sybil mode; two is given zero for send message and one for fact
const Nodesize = (N+1) + (Maxflynode * Eachsessionfly) //Declaration of the tables
var Nodeactive[Nodesize][6] int // nodeactive - this is to maintain whether a particular node is active or not and who introduced it [0] active or not and [1] introducer.
var Nodemain[Nodesize][(N+2)*Ne][Na+Nf]int
var Nodeservice[Nodesize][Mi][Nsa+Nf]int
var Nodeservicetable[Mi][Sta]int
var Nodeneighbor[Nodesize][Nodesize+2]int //two increase required, one to accomodate the number of neighbors and another one value more than n
var Fact1 [Fsize][Fa+Fae]int
var Fact2 [N+1][Fe][Fa]int
var Tscore [Nf][Nodesize][Tsa+Tsae]float64
var Tcompute [Nf][Nodesize][Nodesize*Nodesize][Sca+Scae]float64  // for keeping the vote values
var Bloomvote [1000][Nodesize] int // this variable is to control the double voting on user report
var Presentsession = 0 // presentsession - this indicates the session
var Sybilvoteoption int // this is to ensure all sybil nodes will go for the same activity.
var Msecond = time.Duration(4500) // how many seconds delay required so that all go routines will complete the job - this is in activity function
var Dsecond = time.Duration(40) // Dsecond should be greater than Msecond; how many seconds delay required so that all go routines will complete the job - this is in Main function
var Colludearray[Colludeentry][10] int // colludearray - this is to support the collusion attack
var Sybilarray[Sybilentry][10] int // Sybilarray - this is to support the sybil attack
var Totalnodes = N // totalnodes - what is the total node at present
