//Authors: S.Venkatesan, Sandeep Kumar Shukla and Yuvaraj Rajendra

package main
import (
		"fmt"
		"time"
		"math/rand"
		"os"
		"strconv"
		"variables"
		"initialize"
		"enduser"
       )



var specificnode int
var resultprint int
func updateresource(nodei int, nodesend int, serviceid int, servicevalue int, messagecorrect int, nodetype int, trustmodel int) {
	for i := 0; i < vars.Mi; i++ {
		//fmt.Println("servie",serviceid)
		if vars.Nodeservice[nodei][serviceid][0] == -1 {
			vars.Nodeservice[nodei][serviceid][0] = -1
			vars.Nodeservice[nodei][serviceid][1] = nodetype
			//vars.Nodeservice[nodei][serviceid][2] = -1 //otherwise servicevalue
			vars.Nodeservice[nodei][serviceid][3] = messagecorrect
			vars.Nodeservice[nodei][serviceid][4] = nodesend
			if vars.Resourceupdate[trustmodel] == 1 { 
				vars.Nodeservice[nodei][serviceid][vars.Nsa + trustmodel] = servicevalue
			}
			noupdate := 0
			for fu := 0; fu < vars.Nf; fu++ { // goes for all the trust models; fu refers the function number
				if vars.Resourceupdate[fu] == 1 && vars.Nodeservice[nodei][serviceid][vars.Nsa + fu] != -1 {

				} else {
					noupdate = 1
				}
			}
			if noupdate == 0 {
				vars.Nodeservice[nodei][serviceid][2] = servicevalue // update if all trust model accepts it 
				vars.Nodeservice[nodei][serviceid][0] = 1 // update if all trust model accepts it 
			}
			break
		}
	}
}

func finalneighbors(session string) {
	filename := "graphsession"+session+".txt"
	f, _ := os.OpenFile(filename, os.O_APPEND|os.O_CREATE|os.O_WRONLY, 0644)
	for i := 1; i < vars.Nodesize ; i++ {
		if vars.Nodeneighbor[i][0] == 0 {
			continue
		}
		str:= strconv.Itoa(i)
		f.Write([]byte(str))
		f.Write([]byte("-"))
		alimit := vars.Nodeneighbor[i][0]
		for j := 1; j <= alimit; j++ {
			if vars.Nodeneighbor[i][j] == -1 {
				break
			}
			str = strconv.Itoa(vars.Nodeneighbor[i][j])
			f.Write([]byte(str))
			f.Write([]byte(","))
		}
		f.Write([]byte("\n"))
	}
	f.Close()
}


//Alloting the neighbours initially
func neighbourallot() {
	//fmt.Println("######## Node Neighbors Allocation ##########","malicious nodes=",vars.Mn,"sybil nodes=",vars.Sn)
	fmt.Println("######## Node Neighbors Allocation ##########")
	f, _ := os.OpenFile("initgraph.txt", os.O_APPEND|os.O_CREATE|os.O_WRONLY, 0644)
	copyN := vars.N
	for i:= 1; i <= copyN; i++ {
		ini.UniqueRand(i)
		str:= strconv.Itoa(i)
		f.Write([]byte(str))
		f.Write([]byte("-"))
		for j := 1; j <= copyN+1; j ++ {
			if vars.Nodeneighbor[i][j] == -1 {
				break
			}
			str = strconv.Itoa(vars.Nodeneighbor[i][j])
			f.Write([]byte(str))
			f.Write([]byte(","))
		}
		f.Write([]byte("\n"))
		//fmt.Println(i,"--",vars.Nodeneighbor[i])
	}
	f.Close()
	for i := copyN + 1; i < vars.Nodesize; i++ {
		vars.Nodeneighbor[i][0] = 0
		vars.Nodeneighbor[i][1] = -1
	}
}


func autoserviceupdate() {
	for i := 0; i < vars.Mi; i++ {
		rand.Seed(time.Now().UnixNano())
		status := rand.Intn(vars.Nsv[i])
		vars.Nodeservicetable[i][0] = status
	}
	//resource() //update resource table of all nodes
}

//user can insert the additional attribute and equivalent computation here.
// Now it is simply filled with 0
func factadditionalattri(nodei int, entryrow int) {
	for j := vars.Fa; j < vars.Fae; j++ {
	   vars.Fact1[entryrow][j] =  0
	}
}

// this function allows the node to make the entry in the table for a recieved attack message and look for the votes
func factvoteentry(nodei int, messageid int, nodetype int, statusid int, target int) {
	for i := 0; i < vars.Fe; i++ {
		if vars.Fact1[i][0]  == -1 {
			vars.Fact1[i][0] = 2 // fact type
			vars.Fact1[i][1] = nodei // Node identity
			vars.Fact1[i][2] = messageid // Message identity
			vars.Fact1[i][3] = nodetype // Node Type
			vars.Fact1[i][4] = vars.Presentsession // session
			vars.Fact1[i][6] = statusid // message status
			vars.Fact1[i][8] = target // message sender or the target against whom the entry is
			vars.Fact1[i][11] = vars.Nodeactive[nodei][4] // storing the factvoteentry post node's present location
			if nodei <= vars.Colnode && target > vars.Colnode { // cast the negative vote and then call for colluded attack.
                                vars.Colludearray[vars.Colludeindex][0] = 1 // Refers the type of activity. 1 indicates the factpost.
                                vars.Colludearray[vars.Colludeindex][1] = i // Refers the index.
                                vars.Colludeindex++
                        }
			//if nodeactive[nodei][2] == 2 { // cast the negative vote and call for the sybil attack if target is not the sybil node.
			if vars.Nodeactive[nodei][2] == 2 && vars.Nodeactive[target][2] != 2 { // cast the negative vote and then call for sybil attack.
                                vars.Sybilarray[vars.Sybilindex][0] = 1 // Refers the type of activity. 1 indicates the factpost.
                                vars.Sybilarray[vars.Sybilindex][1] = i // Refers the index.
                                vars.Sybilindex++
                        }

		}
	}
}

//this function is to cast the vote and to support the factvote function
func factvotecast(nodei int, messageid int, index int) {
	if vars.Nodeservice[nodei][messageid][0] == 1 && vars.Bloomvote[vars.Fact1[index][7]][nodei] != 1{
		if vars.Nodeservice[nodei][messageid][2] != vars.Fact1[index][6] {
			vars.Fact1[index][9] = vars.Fact1[index][9] + 1 // attack report is valid
		} else {	
			vars.Fact1[index][10] = vars.Fact1[index][10] + 1 // attack report is invalid
		}
		vars.Bloomvote[vars.Fact1[index][7]][nodei] = 1
	}
}

//this function is for voting in favor or against the facts posted by victims against a sender
func factvote(nodei int) {
	votes := 0
	noofvote := ini.Randomrangeint(1,5) // this can be modified. It says maximum upto 5 messages it will vote 
	//if cattack == 1 && (collideleader[0] == nodei  || collideleader[1] == nodei) {
	if nodei <= vars.Colnode {
		for j := 0; j < vars.Colludeindex; j++ {
			if vars.Colludearray[j][0] == 1 {
				i := vars.Colludearray[j][1] 
				messageid := vars.Fact1[i][2] 
				factvotecast(nodei, messageid, i)
			}
		}
	}
	if vars.Nodeactive[nodei][2] == 2 { // if the claim is against the sybil attacker.
		for j := 0; j < vars.Sybilentry; j++ {
			if vars.Sybilarray[j][0] == 1 {
				i := vars.Sybilarray[j][1] 
				messageid := vars.Fact1[i][2] 
				factvotecast(nodei, messageid, i)
			}
		}
	} 
 
	for i := 0; i < vars.Fe; i++ {
		if vars.Fact1[i][0] == 2 && vars.Fact1[i][4] == vars.Presentsession - 1 { // this refers for the voting of factvote type and computing for the previous session
			messageid := vars.Fact1[i][2] 
			factvotecast(nodei, messageid, i)
			//if collide == 1 && (collideleader[0] == nodei  || collideleader[1] == nodei) {
			if nodei == vars.Fact1[i][8] && nodei <= vars.Colnode { // if the claim is against the attacker then call for colluded attack.
				vars.Colludearray[vars.Colludeindex][0] = 1 // Refers the type of activity. 1 indicates the factpost.
				vars.Colludearray[vars.Colludeindex][1] = i // Refers the index.
				vars.Colludeindex++
			}
			//if nodei == vars.Fact1[i][8] && vars.Nodeactive[nodei[2] == 2 { // if the claim is against the sybil attacker.
			if nodei == vars.Fact1[i][8] && nodei == vars.Mn + vars.Dn + 1 { // if the claim is against the attacker that is its own then call for colluded attack.
 				vars.Sybilarray[vars.Sybilindex][0] = 1 // Refers the type of activity. 1 indicates the factpost.
				vars.Sybilarray[vars.Sybilindex][1] = i // Refers the index.
				vars.Sybilindex++
			}
			votes ++
			if votes == noofvote {
				break
			}
		} 
	}
}


//Node makes entry into the fact table
//array 0, node id | array 1, message id | array 2 genuine | array 3 present session | array 4 count
//array 5 message status
func factentry(nodei int) {
	rand.Seed(time.Now().UnixNano())
	messageid := rand.Intn(vars.Mi)
	nomessage := 1
	for j := 0; j < vars.Mi; j++ {
		if vars.Nodeservice[nodei][messageid][0] != -1 {
			nomessage = 0
			break;
		}	
		rand.Seed(time.Now().UnixNano())
		messageid = rand.Intn(vars.Mi)
	}

	if nodei <= vars.Colnode { // if the claim is against the attacker then call for colluded attack.
		for k1 := 0; k1 < vars.Colludeindex; k1++ {
			if vars.Colludearray[k1][0] == 2 && vars.Colluderbloom[nodei][1][k1] == 0{ //here 1 refers for the fact table
				messageid = vars.Colludearray[k1][1]
				vars.Colluderbloom[nodei][1][k1] = 1
				nomessage = 0
				break
			}
		}
	}
	if vars.Nodeactive[nodei][2] == 2 { // if the claim is against the attacker then call for colluded attack.
		for k1 := 0; k1 < vars.Sybilentry; k1++ {
			if vars.Sybilarray[k1][0] == 2 && vars.Sybilbloom[nodei][1][k1] == 0{ //here 1 refers for the fact table
				messageid = vars.Sybilarray[k1][1]
				vars.Sybilbloom[nodei][1][k1] = 1
				nomessage = 0
				break
			}
		}
	}

	if nomessage == 0 {
		for i := 0; i < vars.Fe; i++ {
			if vars.Fact1[i][0] == 1 && vars.Fact1[i][1] == nodei && vars.Fact1[i][2] == messageid && vars.Def == 0 { //global def is the support of duplication. 0 means no duplicate entry
				//vars.Fact1[i][1] = vars.Nodeservice[nodei][messageid][0]
				//vars.Fact1[i][2] = messageid
				//vars.Fact1[i][3] = vars.Nodeservice[nodei][messageid][1] //node genuine or malicious
				vars.Fact1[i][6] = vars.Nodeservice[nodei][messageid][2]
				vars.Fact1[i][5] = vars.Fact1[i][5] + 1 
				factadditionalattri(nodei, i)
			} else if vars.Fact1[i][0] == -1 {
				count := 0
				if vars.Fec == 1 {
					for k := 0; k < vars.Fe; k++ {
						if vars.Fact1[k][1] == nodei {
							count++
						}
					}
				}
				if count >= vars.Fe {
					break;
				}	
				vars.Fact1[i][0] = 1 // this is to define whether it is fact or voting request. (1) fact and (2) voting request 
				vars.Fact1[i][1] = nodei 
				vars.Fact1[i][2] = messageid 
				vars.Fact1[i][3] = vars.Nodeservice[nodei][messageid][1]
				vars.Fact1[i][6] = vars.Nodeservice[nodei][messageid][2]
				vars.Fact1[i][4] = vars.Presentsession
				vars.Fact1[i][5] = vars.Fact1[i][5] + 1 
				vars.Fact1[i][11] = vars.Nodeactive[nodei][4] 
				factadditionalattri(nodei, i)
				for fu := 0; fu < vars.Nf; fu ++ {
					if vars.Factincentive[fu] == 1 {
						nodeincentivepost(nodei, vars.Factincentvalue[fu], fu, 3) // the value 3 is for the fact posting incentive entry in the array - storage index
					}
				}
			}
		}
	}
}
func neighborcheck(nodei int, neighborid int) bool{
	if nodei == neighborid {
		return true;
	}
	alimit := vars.Nodeneighbor[nodei][0] 
	for i := 1; i <= alimit ; i++ {
		if vars.Nodeneighbor[nodei][i] == neighborid {
			return true
		} else if vars.Nodeneighbor[nodei][i] == -1 {
			break
		} 
	}
   	return false
}

//tcompute array 0, votetype | array 1, votevalue | array 2, voter | array 3 present session
//also possible to give more than one vote but in the same entry
func nodevotepost(voter int, votee int, votetype int, votevalue int, messageid int, messagestatus int, tmodel int) { //tmodel refers the function
	votecount := 0
	for i := 1; i < vars.Nodesize * vars.Nodesize; i++ {
		if int(vars.Tcompute[tmodel][votee][i][2]) == voter {
			if vars.Sessionapplicable[tmodel] == 1 {
				if int(vars.Tcompute[tmodel][votee][i][3]) == vars.Presentsession {
					votecount++
					if vars.Maxvote[tmodel] == 1 {
						break
					}
				}
			} else {
					votecount++
					if vars.Maxvote[tmodel] == 1 {
						break
					}
			}
		}
	}
	if votecount < vars.Maxvote[tmodel] || votevalue == 0{
		i := 0
		identified := 0
		for i = 1; i <= vars.N * vars.N; i++ { 
			if vars.Tcompute[tmodel][votee][i][0] == -1  {
				identified = 1
				break
			}
		}
		if identified == 1 {
			vars.Tcompute[tmodel][votee][i][0] = float64(votetype)
			vars.Tcompute[tmodel][votee][i][1] = float64(votevalue)
			vars.Tcompute[tmodel][votee][i][2] = float64(voter)
			vars.Tcompute[tmodel][votee][i][3] = float64(vars.Presentsession)
			//vars.Tcompute[tmodel][votee][i][4] = float64(vars.Nodeactive[voter][4])
			nodevotepostaddattri(votee, i, tmodel)
			euser.Scorecompute(votee, messageid, votevalue, votetype, tmodel, voter, 1, messagestatus)  // 1 refers the incentive for voting that is for voter
		}
	}
}
	


//this function is to add the additonal attributes in the tcompute table while posting vote 
func nodevotepostaddattri(nodei int, entryid int, tmodel int) {
	for j := vars.Sca; j < vars.Scae; j++ {
		vars.Tcompute[tmodel][nodei][entryid][j] =  0
	}

}

//this function is to add the additonal attributes in the tcompute table while adding incentives
func nodeincenpostaddattri(nodei int, entryid int, tmodel int) {
	for j := vars.Sca; j < vars.Scae; j++ {
		vars.Tcompute[tmodel][nodei][entryid][j] =  0
	}

}

//this function is to post the incentives on the tcompute and that will be considered for the evaluation
func nodeincentivepost(nodei int, incentivevalue int, tmodel int, entryincentive int) {  //tmodel is the trust model
	incentivecount := 0
	for i := 1; i <= vars.N * vars.N; i++ { 
		if vars.Tcompute[tmodel][nodei][i][0] == 2 {
			incentivecount++
		}
		if vars.Tcompute[tmodel][nodei][i][0] == -1 &&  incentivecount < vars.Maxincentive[tmodel]  {
			vars.Tcompute[tmodel][nodei][i][0] = 2 // this refers the incentive
			vars.Tcompute[tmodel][nodei][i][1] = float64(incentivevalue)
			vars.Tcompute[tmodel][nodei][i][2] = float64(nodei)
			vars.Tcompute[tmodel][nodei][i][3] = float64(vars.Presentsession) 
			vars.Tscore[tmodel][nodei][0] = vars.Tscore[tmodel][nodei][0] + float64(incentivevalue) 
			nodeincenpostaddattri(nodei, i, tmodel)
			euser.Scorecompute(nodei, 0, incentivevalue, 2, tmodel, nodei, entryincentive, -1) // the last 2 is for the incentive entry
			break
		}
	}
}





// This function is to perform the action on the received responses. Whether to accept the message and vote positive or negative and reject.
func noderesponseaction(nodei int) {
	rand.Seed(time.Now().UnixNano())
	entryid := rand.Intn(vars.Nentry)
	identified := 0
	//votevalue := 0 //negative vote means 0
	pvote := 1 //positive vote value 1
	nvote := 0 //positive vote value 1
	for i := 0; i < vars.Nentry; i++ {
		//if (vars.Nodemain[nodei][entryid][10] == 2 || vars.Nodemain[nodei][entryid][0] == 2)  && vars.Nodemain[nodei][entryid][8] == vars.Presentsession && vars.Nodemain[nodei][entryid][4] != nodei {
		if (vars.Nodemain[nodei][entryid][10] == 2 || vars.Nodemain[nodei][entryid][0] == 2)  && vars.Nodemain[nodei][entryid][4] != nodei {
			identified = 1
			break
		} else {
			entryid = rand.Intn(vars.Nentry)
		}
	}
	if identified == 1 {
		accept := -1
		negative := 0
		output := -1
		output1 := -1
		messageaccept := 0
		messageidentity := vars.Nodemain[nodei][entryid][5]
		//for fu := 0; fu < vars.Nf; fu++ { // goes for all the trust models; fu refers the function number
		for fu := 0; fu < vars.Nf; fu++ { // goes for all the trust models; fu refers the function number
			//votevalue := 0 //negative vote means 0
			if vars.Blockincentive[fu] == 1 {
				rand.Seed(time.Now().UnixNano())
				mining := rand.Intn(2)
				if mining == 1 {
					nodeincentivepost(nodei, vars.Blockincentvalue[fu], fu, 2) // incentive entry for the block mining
				}
			}
			pvotevalue := ini.Randomrangeint(1,vars.Vvalue[fu])
			nvotevalue := ini.Randomrangeint(0,vars.Nvalue[fu])
                        nvotevalue = nvotevalue * -1

			if nodei > vars.Mn + vars.Dn + vars.Sn {
				//if vars.Nodeservice[nodei][messageidentity][0] != -1 && vars.Nodemain[nodei][entryid][0] == 2 {
				if vars.Nodeservice[nodei][messageidentity][0] != -1 || vars.Nodeservice[nodei][messageidentity][vars.Nsa + fu] != -1{
					if (vars.Nodeservice[nodei][messageidentity][2] == vars.Nodemain[nodei][entryid][6]) || (vars.Nodeservice[nodei][messageidentity][vars.Nsa + fu] == vars.Nodemain[nodei][entryid][6]) { //based on service availability
					//if (vars.Nodeservice[nodei][messageidentity][2] == vars.Nodemain[nodei][entryid][6]) { //based on service availability
						rand.Seed(time.Now().UnixNano())
						voteoption := rand.Intn(2)
						//vars.Nodemain[nodei][entryid][9] = 1  //message accept (1)
						vars.Nodemain[nodei][entryid][vars.Na + fu] = 1  //message accept (1)
						if voteoption == 1 {
							//votevalue := ini.Randomrangeint(1,vars.Vvalue[fu])
							//fmt.Println("hello")
							nodevotepost(nodei, vars.Nodemain[nodei][entryid][4], pvote, pvotevalue, vars.Nodemain[nodei][entryid][5], vars.Nodemain[nodei][entryid][6], fu) // positive vote  --- range random to be checked. don
							//vars.Nodemain[nodei][entryid][9] = 1  //message accept (1)
							continue
						}
					} else {
						vars.Nodemain[nodei][entryid][vars.Na + fu] = -1  //message accept (1)
						if fu == 0 {
							//vars.Nodemain[nodei][entryid][vars.Na + fu] = 1  //message accept (1)
						}
						rand.Seed(time.Now().UnixNano())
						negvote := rand.Intn(2)
						if negvote == 1 {
							if vars.Factventry[fu] == 1 {
								//vars.Nodemain[nodei][entryid][vars.Na + fu] = -1  //message accept (1)
								factvoteentry(nodei, messageidentity, vars.Nodemain[nodei][entryid][7], vars.Nodemain[nodei][entryid][6], vars.Nodemain[nodei][entryid][4])  // to take the vote and prove the attack
							} else {
								nodevotepost(nodei, vars.Nodemain[nodei][entryid][4], nvote, nvotevalue, vars.Nodemain[nodei][entryid][5], vars.Nodemain[nodei][entryid][6], fu) //negative vote
							}
						}
						continue
					}
				}
			}
			messageaccept = euser.Decisioncall(nodei, fu, vars.Nodemain[nodei][entryid][4]) // this is based on score
			if messageaccept == 2 || messageaccept == 0 { // 2 refers attacker
				accept = -1
			} else {
				accept = 1
			}
			if accept == 0{
				//output = factcompute(vars.Nodemain[nodei][entryid][5])
				output = euser.Decisioncallfact(nodei, fu, vars.Nodemain[nodei][entryid][5], vars.Nodemain[nodei][entryid][4], vars.Nodemain[nodei][entryid][6]) // based on fact table
				output1 = euser.Decisioncallresponse(nodei, fu, vars.Nodemain[nodei][entryid][5], vars.Nodemain[nodei][entryid][6], vars.Nodemain[nodei][entryid][4])//based on response
				if output == 1 && output1 == 1 { 
				//if output == 1 || (nodei <= vars.Colsnode && vars.Nodemain[nodei][entryid][4] <= vars.Colsnode) { // either true or colluded ballot stuffing
					accept = 1
				}else if output == 0 && output1 == 0 {
					accept = -1
					negative = 1
				}else if output == 1 {
					accept = 1
				}else if output == 0 {
					accept = -1
				} else {
					accept = 0
				}
			}
			if nodei > vars.Mn + vars.Dn + vars.Sn {
				vars.Nodemain[nodei][entryid][vars.Na + fu] = accept
				rand.Seed(time.Now().UnixNano())
				voteoption := rand.Intn(2)
				if voteoption == 1 && accept == 1 && negative == 0{
					nodevotepost(nodei, vars.Nodemain[nodei][entryid][4], pvote, pvotevalue, vars.Nodemain[nodei][entryid][5], vars.Nodemain[nodei][entryid][6], fu) // positive vote  --- range random to be checked
					updateresource(nodei, vars.Nodemain[nodei][entryid][4], vars.Nodemain[nodei][entryid][5], vars.Nodemain[nodei][entryid][6], vars.Nodemain[nodei][entryid][11], vars.Nodemain[nodei][entryid][7], fu) // update the resource

				}
				if negative == 1 {
					nodevotepost(nodei, vars.Nodemain[nodei][entryid][4], nvote, nvotevalue, vars.Nodemain[nodei][entryid][5], vars.Nodemain[nodei][entryid][6], fu) //negative vote
				}
			} else if nodei > vars.Mn && nodei <= vars.Dn && nodei != 0 { 
				rand.Seed(time.Now().UnixNano())
		       	 	voteoption := rand.Intn(2)
				if voteoption == 1 && accept == 1{
					vars.Nodemain[nodei][entryid][vars.Na + fu] = accept
					nodevotepost(nodei, vars.Nodemain[nodei][entryid][4], pvote, pvotevalue, vars.Nodemain[nodei][entryid][5], vars.Nodemain[nodei][entryid][6], fu) // positive vote -- range random function to be checked and added
					updateresource(nodei, vars.Nodemain[nodei][entryid][4], vars.Nodemain[nodei][entryid][5], vars.Nodemain[nodei][entryid][6], vars.Nodemain[nodei][entryid][11], vars.Nodemain[nodei][entryid][7], fu) // update the resource
				} else {
					vars.Nodemain[nodei][entryid][vars.Na + fu] = 0 //reject withou worrying whether message is correct or not
					nodevotepost(nodei, vars.Nodemain[nodei][entryid][4], nvote, nvotevalue, vars.Nodemain[nodei][entryid][5], vars.Nodemain[nodei][entryid][6], fu) //negative vote
				}
			} else if nodei > vars.Mn + vars.Dn && nodei <= vars.Sn && nodei != 0 {
				rand.Seed(time.Now().UnixNano())
				badmouth := rand.Intn(2)
				if vars.Bsm == 1 && nodei == vars.Mn + vars.Dn + 1 { //only very first node go for the sybil attack others will do the normal process.
					//if vars.Nodemain[nodei][entryid][4] > vars.Dn && vars.Nodemain[nodei][entryid][4] <= vars.Sn
					if vars.Nodeactive[vars.Nodemain[nodei][entryid][4]][2] == 2 {
						vars.Nodemain[nodei][entryid][vars.Na + fu] = 1 //always accept
						tmpnode := nodei
                                                for k := 1; k <= vars.Sn; k++ {
                                                        nodei = vars.Mn + vars.Dn + k
							//nodevotepost(nodei, vars.Nodemain[nodei][entryid][4], pvote, votevalue, vars.Nodemain[nodei][entryid][5], vars.Nodemain[nodei][entryid][6], fu) // positive vote -- range random function to be checked and added
							//votevalue := ini.Randomrangeint(1,vars.Vvalue[fu])
							nodevotepost(nodei, vars.Nodemain[tmpnode][entryid][4], pvote, pvotevalue, vars.Nodemain[tmpnode][entryid][5], vars.Nodemain[tmpnode][entryid][6], fu) // positive vote -- range random function to be checked and added
                                                }
						//fmt.Println("------------ami")
                                                nodei = tmpnode
					//} else if vars.Bsm == 1 && (vars.Nodemain[nodei][entryid][4] <= vars.Mn + vars.Dn && vars.Nodemain[nodei][entryid][4] > vars.Sn) && badmouth == 1 {
					} else if vars.Bsm == 1 && vars.Nodeactive[vars.Nodemain[nodei][entryid][4]][2] != 2 && badmouth == 1 {
						vars.Nodemain[nodei][entryid][vars.Na + fu] = -1 //always reject
						tmpnode := nodei
	                                        for k := 1; k <= vars.Sn; k++ {
		                                        nodei = vars.Mn + vars.Dn + k
							//votevalue := ini.Randomrangeint(1,vars.Nvalue[fu])
		                                        //votevalue = votevalue * -1
							nodevotepost(nodei, vars.Nodemain[tmpnode][entryid][4], nvote, nvotevalue, vars.Nodemain[tmpnode][entryid][5], vars.Nodemain[tmpnode][entryid][6], fu) //negative vote
							//nodevotepost(nodei, vars.Nodemain[nodei][entryid][4], nvote, votevalue, vars.Nodemain[nodei][entryid][5], vars.Nodemain[nodei][entryid][6], fu) //negative vote
                	                        }
                        	                nodei = tmpnode
					}
				} else {
					rand.Seed(time.Now().UnixNano())
					voteoption := rand.Intn(2)
					if voteoption == 1 && accept == 1 && negative == 0{
						vars.Nodemain[nodei][entryid][vars.Na + fu] = accept
						//votevalue := ini.Randomrangeint(1,vars.Vvalue[fu])
						nodevotepost(nodei, vars.Nodemain[nodei][entryid][4], pvote, pvotevalue, vars.Nodemain[nodei][entryid][5], vars.Nodemain[nodei][entryid][6], fu) // positive vote  --- range random to be checked
						tmpnode := nodei
                                        	for k := 1; k <= vars.Sn; k++ {
                                                	nodei = vars.Mn + vars.Dn + k
	                                                updateresource(nodei, vars.Nodemain[nodei][entryid][4], vars.Nodemain[nodei][entryid][5], vars.Nodemain[nodei][entryid][6], vars.Nodemain[nodei][entryid][11], vars.Nodemain[nodei][entryid][7], fu) // update the resource
        	                                }
                	                        nodei = tmpnode
					}
					if negative == 1 {
						//votevalue := ini.Randomrangeint(1,vars.Nvalue[fu])
                                        	//votevalue = votevalue * -1
						nodevotepost(nodei, vars.Nodemain[nodei][entryid][4], nvote, nvotevalue, vars.Nodemain[nodei][entryid][5], vars.Nodemain[nodei][entryid][6], fu) //negative vote
						vars.Nodemain[nodei][entryid][vars.Na + fu] = accept
					}
				}
			} else if nodei < vars.Mn {
				if nodei <= vars.Colnode {
					if vars.Nodemain[nodei][entryid][4] <= vars.Colnode {
						//votevalue := ini.Randomrangeint(1,vars.Vvalue) //--------------updated
						//votevalue := ini.Randomrangeint(1,vars.Vvalue[fu])
						nodevotepost(nodei, vars.Nodemain[nodei][entryid][4], pvote, pvotevalue, vars.Nodemain[nodei][entryid][5], vars.Nodemain[nodei][entryid][6], fu) // positive vote  --- range random to be checked
						vars.Nodemain[nodei][entryid][vars.Na + fu] = accept
						actionsupport(nodei, vars.Nodemain[nodei][entryid][4], pvote, pvotevalue, vars.Nodemain[nodei][entryid][5], fu) // for bulk positive vote
			               	} else {
						rand.Seed(time.Now().UnixNano())
						voteoption := rand.Intn(2)
						if voteoption == 1 {
							//votevalue := ini.Randomrangeint(1,vars.Nvalue[fu])
		                                        //votevalue = votevalue * -1
							nodevotepost(nodei, vars.Nodemain[nodei][entryid][4], nvote, nvotevalue, vars.Nodemain[nodei][entryid][5], vars.Nodemain[nodei][entryid][6], fu) //negative vote
							actionsupport(nodei, vars.Nodemain[nodei][entryid][4], nvote, nvotevalue, vars.Nodemain[nodei][entryid][5], fu) // positive vote  --- range random to be checked
						}
					}
					for k1 := 0; k1 < vars.Colludeindex; k1++ {
	          				if vars.Colludearray[k1][0] == 3 && vars.Colluderbloom[nodei][2][k1] == 0{
	                                		//messageid := vars.Colludearray[k1][1]
			                                //neighborid := vars.Colludearray[k1][2] // even if neighbor is not in the neighbors list, a node can send message using the colluded information
			                                vars.Colluderbloom[nodei][2][k1] = 1  // 0 indicates the voting 
							//votevalue := ini.Randomrangeint(1,vars.Vvalue) //--------------updated
							//votevalue := ini.Randomrangeint(1,vars.Vvalue[fu])
							nodevotepost(nodei, vars.Colludearray[k1][1], vars.Colludearray[k1][2], vars.Colludearray[k1][3], vars.Colludearray[k1][4], vars.Nodemain[nodei][entryid][6], vars.Colludearray[k1][5])  // positive vote  --- range random to be checked
	                		                break
						}
					}
                        	} else {
					rand.Seed(time.Now().UnixNano())
					voteoption := rand.Intn(2)
					if voteoption == 1 {
						//votevalue := ini.Randomrangeint(1,vars.Vvalue) //--------------updated
						//votevalue := ini.Randomrangeint(1,vars.Vvalue[fu])
						nodevotepost(nodei, vars.Nodemain[nodei][entryid][4], pvote, pvotevalue, vars.Nodemain[nodei][entryid][5], vars.Nodemain[nodei][entryid][6], fu) // positive vote  --- range random to be checked
					} else {
					       // votevalue := ini.Randomrangeint(1,vars.Nvalue[fu])
                                                //votevalue = votevalue * -1
						nodevotepost(nodei, vars.Nodemain[nodei][entryid][4], nvote, nvotevalue, vars.Nodemain[nodei][entryid][5], vars.Nodemain[nodei][entryid][6], fu) //negative vote
					}
				}	
                	}
		}
	}
}

//this function is to support the node response function to go for the colluded vote.
func actionsupport(nodei int, target int, votetype int, votevalue int, messageid int, tmodel int) {
	exist := 0
	for k := 0; k < vars.Colludeindex; k++ { // check whether already colluded attack in progress
		if vars.Colludearray[k][0] == 3 {
		        if vars.Colludearray[k][1] == target {
			        exist = 1
			        break
			 }
		 }
        }
        if exist == 0 && vars.Colludeindex < vars.Colludeentry - 1{
		vars.Colludearray[vars.Colludeindex][0] = 3 // 3 indicates normal voting.
		vars.Colludearray[vars.Colludeindex][1] = target // Refers the target.
		vars.Colludearray[vars.Colludeindex][2] = votetype // Refers the vote type; positive or negative.
		vars.Colludearray[vars.Colludeindex][3] = votevalue // Refers the vote value
		vars.Colludearray[vars.Colludeindex][4] = messageid // Refers the message identity
		vars.Colludearray[vars.Colludeindex][5] = tmodel // Refers the trust model
		vars.Colluderbloom[nodei][2][vars.Colludeindex] = 1  // 2 indicates the voting
		vars.Colludeindex++
        }
}


// Node activity on the request of the neighbour node. 1 refers request and 2 refers response
// array 0, request(1)/response(2)| array 1, (-1) expired  or  (1) non-expired| array 2, owner id (received the request) | array 3, uniqueness entry id 
// array 4, neighbor(sender of the request) identity | array 5, message identity | array 6, status identity | array 7 genuine/non-genuine/sybil/diguise
// array 8, session identity | array 9, accept(1) or reject(-1) or nodecision(0) | array 10, set response is given for the neighbor (that is 2)
// array 11, correct message(1) or incorrect message(-1).
func noderesponse(nodei int) {
	rand.Seed(time.Now().UnixNano())
	entryid := rand.Intn(vars.Nentry)
	identified := 0
	for i := 0; i < vars.Nentry; i++ {
		if vars.Nodemain[nodei][entryid][0] == 1 && vars.Nodemain[nodei][entryid][1] != -1 && vars.Nodemain[nodei][entryid][8] == vars.Presentsession && vars.Nodemain[nodei][entryid][5] != -1 {
			identified = 1
			break
		} else {
			entryid = rand.Intn(vars.Nentry)
		}
	}  
	if identified == 1 {
		uniqueentryid := vars.Nodemain[nodei][entryid][3]
		//uniqueentryid := entryid
		neighborid := vars.Nodemain[nodei][entryid][4] // 4 was there
		messageid := vars.Nodemain[nodei][entryid][5]

		for i := 0; i < vars.Nentry; i++ {
		       if vars.Nodemain[neighborid][i][3] ==  uniqueentryid && vars.Nodeservice[nodei][messageid][0] != -1 {
			       vars.Nodemain[neighborid][i][10] = 2 //set the response in the neighbour otherwise 0		
			       //fmt.Println("Nodeid = ", neighborid, "nei=", vars.Nodemain[neighborid][i][5], "messageid =", messageid,"service= ",vars.Nodeservice[nodei][messageid][2],"i=",i)
			       //fmt.Println("service", vars.Nodeservice[nodei][messageid])
			       //fmt.Println("neight", vars.Nodemain[neighborid][i])
			       //fmt.Println("main",vars.Nodemain[nodei][entryid])
			       vars.Nodemain[neighborid][i][6] = vars.Nodeservice[nodei][messageid][2]		
			       vars.Nodemain[neighborid][i][7] = vars.Nodeservice[nodei][messageid][1]		
			       vars.Nodemain[neighborid][i][11] = vars.Nodeservice[nodei][messageid][3]		
			       vars.Nodemain[neighborid][i][12] = vars.Nodeactive[nodei][4]		
			       //fmt.Println("aa-service", vars.Nodeservice[nodei][messageid])
			       //fmt.Println(nodei, neighborid,"aa-neight", vars.Nodemain[neighborid][i])
			       //fmt.Println(nodei,"aa-main",vars.Nodemain[nodei][entryid])

				if vars.Nodemain[neighborid][i][11] == 0 {
			
			       }
			       vars.Nodemain[nodei][entryid][1] = -1 
			       vars.Nodemain[nodei][entryid][9] = 1 
			       noderesponseadditionalattri(nodei, neighborid, i, entryid)
			       break
			}
		} 
		neighboradd(nodei, neighborid)
		/*if neighborcheck(nodei, neighborid) ==  false {
			availableneighbor := vars.Nodeneighbor[nodei][0]
			vars.Nodeneighbor[nodei][availableneighbor+1] = neighborid
			vars.Nodeneighbor[nodei][0] = availableneighbor + 1
		}*/
	}	
}

func neighboradd (nodei int, neighborid int) {
	if neighborcheck(nodei, neighborid) ==  false {
			availableneighbor := vars.Nodeneighbor[nodei][0]
			vars.Nodeneighbor[nodei][availableneighbor+1] = neighborid
			vars.Nodeneighbor[nodei][0] = availableneighbor + 1
	}
}

// This function is for additional attributes in noderesponse
func noderesponseadditionalattri(nodei int, neighborid int, neighborentryid int, nodeentryid int) {
	for j := vars.Na+vars.Nf; j < vars.Nae; j++ {
	   vars.Nodemain[nodei][nodeentryid][j] =  0
	   vars.Nodemain[neighborid][neighborentryid][j] =  0
	}
}


//This function is to send resource message to the neighbours without any request
func sendmessage(nodei int) {
	rand.Seed(time.Now().UnixNano())
        neighborid := rand.Intn(vars.Nodeneighbor[nodei][0])
        identified := 0
        neighborid = vars.Nodeneighbor[nodei][ini.Randomrangeint(1,vars.Nodeneighbor[nodei][0])]
        identified = identified + 1
        nentryid := 0 //finding neighbor node free entry in the table
        for i := 0; i < vars.Nentry; i++ {
                if vars.Nodemain[neighborid][i][1] == -1 {
                        nentryid = i;
			identified = identified + 1
                        break
                }
        }
        oentryid := 0 //finding  node's free entry in the table
        for i := 0; i < vars.Nentry; i++ {
                if vars.Nodemain[neighborid][i][1] == -1 {
                        oentryid = i
			identified = identified + 1
			break
                }
        }
	rand.Seed(time.Now().UnixNano())
	uniqueid := rand.Intn(1000000)
	var messageid int
	for i := 0; i < 200; i++ {  //in 100 attempts it may find randomly available message identity
		rand.Seed(time.Now().UnixNano())
		messageid = rand.Intn(vars.Mi)
                if vars.Nodeservice[nodei][messageid][0] != -1 {
			identified = identified + 1
			break
                }
        }
	if nodei <= vars.Colnode { // if the claim is against the attacker then call for colluded attack.
		for k1 := 0; k1 < vars.Colludeentry; k1++ {
			if vars.Colludearray[k1][0] == 2 && vars.Colluderbloom[nodei][0][k1] == 0{
				messageid = vars.Colludearray[k1][1]
				neighborid = vars.Colludearray[k1][2] // even if neighbor is not in the neighbors list, a node can send message using the colluded information
				vars.Colluderbloom[nodei][0][k1] = 1  // 0 indicates the send message
				break
			}
		}
        }
	//if vars.Activenode[nodei][2]  == 2 { // if the claim is against the sybil attacker.
	if nodei == vars.Mn + vars.Dn + 1 { // if the claim is against the attacker then call for colluded attack.
		for k1 := 0; k1 < vars.Sybilentry; k1++ {
			if vars.Sybilarray[k1][0] == 2 && vars.Sybilbloom[nodei - (vars.Mn+vars.Dn)][0][k1] == 0 {
				messageid = vars.Sybilarray[k1][1]
				neighborid = vars.Sybilarray[k1][2] // even if neighbor is not in the neighbors list, a node can send message using the colluded information
				vars.Sybilbloom[nodei][0][k1] = 1  // 0 indicates the send message
				break
			}
		}
        }
	//fmt.Println("---------------",nodei, messageid,vars.Nodeservice[nodei][messageid])
	if identified == 4 {
		vars.Nodemain[neighborid][nentryid][0] = 2
		vars.Nodemain[neighborid][nentryid][1] = 1
		vars.Nodemain[neighborid][nentryid][2] = neighborid
		vars.Nodemain[neighborid][nentryid][3] = uniqueid 
		vars.Nodemain[neighborid][nentryid][4] = nodei
		vars.Nodemain[neighborid][nentryid][5] = messageid 
		vars.Nodemain[neighborid][nentryid][6] = vars.Nodeservice[nodei][messageid][2] 
		vars.Nodemain[neighborid][nentryid][7] = vars.Nodeservice[nodei][messageid][1] 
		vars.Nodemain[neighborid][nentryid][8] = vars.Presentsession 
		vars.Nodemain[neighborid][nentryid][9] = 0 
		vars.Nodemain[neighborid][nentryid][10] = 0 
		vars.Nodemain[neighborid][nentryid][11] = vars.Nodeservice[nodei][messageid][3] 
		vars.Nodemain[neighborid][nentryid][12] = vars.Nodeactive[nodei][4] 

	//array 2 is owner and array 4 is neighbor (target)
		vars.Nodemain[nodei][oentryid][0] = 3
		vars.Nodemain[nodei][oentryid][1] = 1
		vars.Nodemain[nodei][oentryid][2] = neighborid
		vars.Nodemain[nodei][oentryid][3] = uniqueid 
		vars.Nodemain[nodei][oentryid][4] = nodei
		vars.Nodemain[nodei][oentryid][5] = messageid 
		vars.Nodemain[nodei][oentryid][6] = vars.Nodeservice[nodei][messageid][2] 
		vars.Nodemain[nodei][oentryid][7] = vars.Nodeservice[nodei][messageid][1] 
		vars.Nodemain[nodei][oentryid][8] = vars.Presentsession 
		vars.Nodemain[nodei][oentryid][9] = 0 
		vars.Nodemain[nodei][oentryid][10] = 0 
		vars.Nodemain[nodei][oentryid][11] = vars.Nodeservice[nodei][messageid][3] 
		//vars.Nodemain[nodei][oentryid][12] = vars.Nodeactive[neighborid][3] 
		sendmessageadditionalattri(nodei, neighborid, nentryid, oentryid)
		if nodei <= vars.Colnode { // to enable the colluded attack.
			exist := 0
			for k := 0; k < vars.Colludeindex; k++ { // check whether already colluded attack in progress
				if vars.Colludearray[k][0] == 2 {
					if vars.Colludearray[k][1] == messageid && vars.Colludearray[k][2] == neighborid {
						exist = 1
						break
					}
				}
			}
        		if exist == 0 && vars.Colludeindex < vars.Colludeentry - 1{
				vars.Colludearray[vars.Colludeindex][0] = 2 // Refers the type of activity. 2 indicates the send message.
	                	vars.Colludearray[vars.Colludeindex][1] = messageid // Refers the message identity.
	                	vars.Colludearray[vars.Colludeindex][2] = neighborid // Refers the neighbor identity.
				vars.Colluderbloom[nodei][0][vars.Colludeindex] = 1  // 0 indicates the send message
                		vars.Colludeindex++
			}
                }
		//if vars.Nodeactive[nodei][2] == 2 { // to enable the sybil attack for all sybil node activity.
		if nodei == vars.Mn + vars. Dn + 1 && vars.Sn > 0 { // to enable the sybil attack.
			exist := 0
			for k := 0; k < vars.Sybilindex; k++ { // check whether already colluded attack in progress
				if vars.Sybilarray[k][0] == 2 {
					if vars.Sybilarray[k][1] == messageid && vars.Sybilarray[k][2] == neighborid {
						exist = 1
						break
					}
				}
			}
        		if exist == 0 && vars.Sybilindex < vars.Sybilentry - 1{
				vars.Sybilarray[vars.Sybilindex][0] = 2 // Refers the type of activity. 2 indicates the send message.
	                	vars.Sybilarray[vars.Sybilindex][1] = messageid // Refers the message identity.
	                	vars.Sybilarray[vars.Sybilindex][2] = neighborid // Refers the neighbor identity.
				vars.Sybilbloom[nodei-(vars.Mn+vars.Dn)][0][vars.Sybilindex] = 1  // 0 indicates the send message
                		vars.Sybilindex++
			}
                }

	}
}
//this function is to add the additional attributes for the send message
func sendmessageadditionalattri(nodei int, neighborid int, neighborentryid int, nodeentryid int) {
	for j := vars.Na; j < vars.Nae; j++ {
	   vars.Nodemain[nodei][nodeentryid][j] =  0
	   vars.Nodemain[neighborid][neighborentryid][j] =  0
	}
}



//this function post the node request
//here array 4 is the owner identity and array 2 is the neighbor(target) identity
func noderequest(nodei int) {
	nodeforrandom := 0
	if vars.Nodeneighbor[nodei][0] == 0 {
		nodeforrandom = 1
	} else {
		nodeforrandom = vars.Nodeneighbor[nodei][0]
	}
	//rand.Seed(time.Now().UnixNano())
	//neighborid := randomrangeint(1,nodeforrandom)
        ranvalue := ini.Randomrangeint(1,nodeforrandom)
        neighborid := vars.Nodeneighbor[nodei][ranvalue]
	identified := 0
	nentryid := 0 //finding neighbor free entry in the table
        ik := ini.Randomrangeint(1,vars.N)
	for i := ik; i < vars.Nentry; i++ {
		if vars.Nodemain[neighborid][i][1] == -1 {
			nentryid = i;
			identified = identified + 1
			break
		}
	}
	oentryid := 0 //finding  node's free entry in the table
	if identified == 1 {
		for i := 0; i < vars.Nentry; i++ {
			if vars.Nodemain[nodei][i][1] == -1 {
				oentryid = i
				identified = identified + 1
				break
			}
		}
	}
	if identified  == 2 {
		rand.Seed(time.Now().UnixNano())
		uniqueid := rand.Intn(100000000)
		rand.Seed(time.Now().UnixNano())
		messageid := rand.Intn(vars.Mi)
		vars.Nodemain[neighborid][nentryid][0] = 1
		vars.Nodemain[neighborid][nentryid][1] = 1
		vars.Nodemain[neighborid][nentryid][2] = neighborid
		vars.Nodemain[neighborid][nentryid][3] = uniqueid 
		vars.Nodemain[neighborid][nentryid][4] = nodei
		vars.Nodemain[neighborid][nentryid][5] = messageid 
		vars.Nodemain[neighborid][nentryid][6] = -1 // no value means -1 
		vars.Nodemain[neighborid][nentryid][8] = vars.Presentsession 
		vars.Nodemain[neighborid][nentryid][9] = 0 
		vars.Nodemain[neighborid][nentryid][10] = 0 
		//array 2 is owner and array 4 is neighbor (target)
		vars.Nodemain[nodei][oentryid][0] = 1
		vars.Nodemain[nodei][oentryid][1] = 1
		vars.Nodemain[nodei][oentryid][2] = nodei
		vars.Nodemain[nodei][oentryid][3] = uniqueid 
		vars.Nodemain[nodei][oentryid][4] = neighborid
		vars.Nodemain[nodei][oentryid][5] = messageid 
		vars.Nodemain[nodei][oentryid][6] = -1  // no value means -1
		vars.Nodemain[nodei][oentryid][8] = vars.Presentsession 
		vars.Nodemain[nodei][oentryid][9] = 0 
		vars.Nodemain[nodei][oentryid][10] = 0 
		//fmt.Println(nodei,"sss", vars.Nodemain[nodei][oentryid])
		//fmt.Println(neighborid,"ppp", vars.Nodemain[neighborid][nentryid])
		noderequestadditionalattri(nodei, neighborid, nentryid, oentryid)
	}
}

//this function is to add the additional attributes for the noderequest message
func noderequestadditionalattri(nodei int, neighborid int, neighborentryid int, nodeentryid int) {
	for j := vars.Na; j < vars.Nae; j++ {
	   vars.Nodemain[nodei][nodeentryid][j] =  0
	   vars.Nodemain[neighborid][neighborentryid][j] =  0
	}
}


//this reinializes the entry for the next session
func reinitialize() {
	autoserviceupdate()
	//ini.Resource()
	ini.Factinitialize()
	ini.Nodemaininitialize()
	ini.Nodetrustinitialize()
	euser.Scorereinitialize()
	ini.Colludeentryinitialize()
	vars.Presentsession++
}

func newnodeintroduce(nodei int) {
	to := 0
	if vars.Eachsessionfly > 1 {
		to = vars.Maxflynode * vars.Presentsession
	} else {
		to = vars.Maxflynode
	}
	for i := 1; i <= to; i++ {
		if vars.Nodeactive[vars.N+i][0] != 1 {
			vars.Nodeactive[vars.N+i][0] =  1
			vars.Nodeactive[vars.N+i][1] =  nodei
			vars.Nodeactive[vars.N+i][2] =  vars.Nodeactive[nodei][2]
               		vars.Nodeneighbor[vars.N+i][1] = nodei
               		vars.Nodeneighbor[vars.N+i][0] = vars.Mnei
        		var j int
			for j = 2; j <= vars.Mnei; j++ {
               			 vars.Nodeneighbor[vars.N+i][j] = vars.Nodeneighbor[nodei][j]
  		    	}
               		vars.Nodeneighbor[vars.N+i][j] = -1
			vars.Nodeservice[vars.N+i] = vars.Nodeservice[nodei]
			for fu := 0; fu < vars.Nf; fu ++ {
                        	if vars.Introduceincentive[fu] == 1 {
                                	nodeincentivepost(nodei, vars.Introduceincentvalue[fu], fu, 5) // the value 5 is for the introducing new node - storage index
                                }
			}
			neighboradd (nodei, vars.N+i)
			vars.Totalnodes += 1
			go nodeactivity(vars.N+i)
			break
		}
	}
}

// this function is to change the location or region of the device during the simulation
func locchange(nodei int) {
	vars.Nodeactive[nodei][4] = ini.Randomrangeint(0,vars.Numloc)	
}

//Main function for a node to start the process.
func nodeactivity(nodei int) {
	j := 1
	for j = 1; j <= vars.Nos; j++ {	
		i := 1
		for i = 1; i <= vars.Activities; i++ {
			rand.Seed(time.Now().UnixNano())
			decideactivity := rand.Intn(10)
			if decideactivity == 0 {
				factentry(nodei)
				//fmt.Println("Fact-",nodei)
			} else if decideactivity == 1 {
				noderequest(nodei)
				//fmt.Println("request",nodei)
			} else if decideactivity == 2 {
				noderesponse(nodei)
				//fmt.Println("response-",nodei)
			} else if decideactivity == 3 && vars.Maxflynode > 0 {
				iteration := 0
				created := 0
				for k := 0; k < vars.Nf; k++ {
                                	if vars.Introducecond[k] == 1 {
						iteration = iteration + 1
						if euser.Decisionintroduce(nodei, k, nodei) == 1 {
							newnodeintroduce(nodei)
							created = 1
						}
                                        }
                                }
				if (iteration != vars.Nf && created == 0) {
					newnodeintroduce(nodei)
				}
			} else if decideactivity == 4 {
				noderesponseaction(nodei)
			} else if decideactivity == 5 {
				factvote(nodei)
 			} else if decideactivity == 6 { // for whitewashing if the score is above threshold
				rand.Seed(time.Now().UnixNano())
				option := rand.Intn(2)
				if option == 1 {
					for k := 0; k < vars.Nf; k++ {
						if vars.Whitewash[k] == 1 && euser.Nodescore(nodei,k) < vars.Whitethreshold[k] {
							euser.Scoreclean(nodei, k)
						}
					}
				}
			} else if decideactivity == 7 {//osciallation
				if nodei > vars.Mn + vars.Sn + vars.Dn && nodei <= vars.Mn + vars.Sn + vars.Dn + vars.Osn {  
					osctrue := 0
					for k := 0; k < vars.Nf; k++ {
							if euser.Nodescore(nodei, k) >= vars.Oscillation[k] {
								osctrue++
							}
					}
					if osctrue == vars.Nf {
						vars.Nodeactive[nodei][2] = 0
						vars.Nodeservice[nodei] = vars.Nodeservice[1]
						for i := 0; i < vars.Mi; i++ {
							if vars.Nodeservice[nodei][i][0] !=  -1 {
								vars.Nodeservice[nodei][i][4] = nodei
							}
						}
					}
				}
			} else if decideactivity == 8 && vars.Nloc >= 1 { //location change
				locchange(nodei)
			} else {
				sendmessage(nodei)
			}
		//fmt.Println("Session.",j,"--node.",i,"--",nodei)
		}
		time.Sleep(vars.Msecond * time.Millisecond)
		//time.Sleep(vars.Msecond * time.Second)
		//fmt.Println("Session.",j,"--node.",i,"--",nodei,"--",vars.Presentsession)
		if nodei == 1 { // this node will trigger the re-initalization
		//if nodei > 10 || nodei == vars.N - 1 || nodei == 1 { // this node will trigger the re-initalization
		//if resultprint  <= vars.Presentsession { // this node will trigger the re-initalization
	//		for ik := 1; ik <= vars.N; ik++ {
	//			fmt.Println(vars.Nodeservice[ik])
	//		}
			resultprint = resultprint + 1
			fmt.Println("RRRRRound change",nodei,vars.Nos)
			finalneighbors(strconv.Itoa(vars.Presentsession))
			if vars.Presentsession < 1 {  //session should start with 0
				for f := 0; f < vars.Nf; f++ {
						//resultcompute(f,specificnode)
					if vars.Sessionapplicable[f] == 0 {
						resultcompute(f,specificnode)
						if vars.Factventry[f] == 1 {
							euser.Factvotecompute(f)
						}
					}
				}
			}
			//time.Sleep(vars.Msecond * time.Second)
			reinitialize()
		}
	}
}
func resultcompute(f int, nodei int) {
	fmt.Println("Begin-------------------Trust Model",f,"----------------------Begin")
	rand.Seed(time.Now().UnixNano())
	//nodei = ini.Randomrangeint(vars.Mn + vars.Sn + vars.Dn + vars.Colnode, vars.N)
	var nodetotalaccept = 0
	var nodegenuineaccept = 0 
	var totalaccept = 0 
	var genuineaccept = 0 
	var nodecorrecttotal = 0 
	var networkcorrecttotal = 0 
	var nodecorrectaccept = 0 
	var networkcorrectaccept = 0 
	//genuineaccept = 0
	//totalaccept = 0
	size := 0
	if vars.Ontheflynode[f] == 1 {
		size = vars.Nodesize
	} else {
		size = vars.N + 1
	}
	for i := 1; i < size; i++ {
		//if vars.Nodeactive[i][0] != 1 && vars.Nodeactive[i][2] != 3 {
		if vars.Nodeactive[i][0] != 1 || vars.Nodeactive[i][2] != 3 {
			continue
		}
		nodetotalaccept = 0
		nodegenuineaccept = 0
		nodecorrecttotal = 0
		nodecorrectaccept = 0
		for j := 0; j < vars.Nentry; j++ {
					//changed evaluation correct accept *******************************
			if vars.Nodemain[i][j][0] == 2 || vars.Nodemain[i][j][10] == 2 {
				if vars.Ontheflynode[f] == 0 {
					if vars.Nodemain[i][j][2] <= vars.N  && vars.Nodemain[i][j][4] <= vars.N {
						if vars.Nodemain[i][j][vars.Na+f] == 1 { 
							nodetotalaccept++
							totalaccept++
							if vars.Nodemain[i][j][11] == 1{
								nodegenuineaccept++							
								genuineaccept++
							//fmt.Println("Check--",i,vars.Nodemain[nodei][i][9],vars.Nodemain[nodei][i][2], vars.Nodemain[nodei][i][4], vars.Nodemain[nodei][i][11])
							}
						}
						if vars.Nodemain[i][j][11] == 1 && vars.Nodemain[i][j][7] == 3 && (vars.Nodemain[i][j][vars.Na+f] == 1 || vars.Nodemain[i][j][vars.Na+f] == -1){
							nodecorrecttotal++
							networkcorrecttotal++
							if vars.Nodemain[i][j][vars.Na+f] == 1 { 
								nodecorrectaccept++							
								networkcorrectaccept++
							//fmt.Println("Check--",i,vars.Nodemain[nodei][i][9],vars.Nodemain[nodei][i][2], vars.Nodemain[nodei][i][4], vars.Nodemain[nodei][i][11])
							}
						}

					}
				} else {
					if vars.Nodemain[i][j][vars.Na+f] == 1 { 
						totalaccept++
						nodetotalaccept++
						if vars.Nodemain[i][j][11] == 1{
							genuineaccept++
							nodetotalaccept++
						//fmt.Println("Check--",i,vars.Nodemain[nodei][i][9],vars.Nodemain[nodei][i][2], vars.Nodemain[nodei][i][4], vars.Nodemain[nodei][i][11])
						}
					}
					//if vars.Nodemain[i][j][11] == 1 && (vars.Nodemain[i][j][vars.Na+f] == 1 || vars.Nodemain[i][j][vars.Na+f] == -1){
					if vars.Nodemain[i][j][11] == 1 && vars.Nodemain[i][j][7] == 3 && (vars.Nodemain[i][j][vars.Na+f] == 1 || vars.Nodemain[i][j][vars.Na+f] == -1){
						nodecorrecttotal++
						networkcorrecttotal++
						if vars.Nodemain[i][j][vars.Na+f] == 1 { 
							nodecorrectaccept++							
							networkcorrectaccept++
						//fmt.Println("Check--",i,vars.Nodemain[nodei][i][9],vars.Nodemain[nodei][i][2], vars.Nodemain[nodei][i][4], vars.Nodemain[nodei][i][11])
						}
					}

				}
			}
		}
		if i == nodei {
	//		nodeevaluation1 := float64(nodegenuineaccept)/float64(nodetotalaccept)
			//nodeevaluation2 := float64(nodetotalaccept-nodegenuineaccept)/float64(nodetotalaccept)
	//		nodeacceptevaluation := float64(nodecorrectaccept)/float64(nodecorrecttotal)
	//		fmt.Println(nodei,"total = ", nodetotalaccept)
	//		fmt.Println(nodei,"genuine = ", nodegenuineaccept)
	//		fmt.Println(nodei,"Genuine Acceptance = ", nodeevaluation1)
			//fmt.Println(nodei,"Incorrect Acceptance = ", nodeevaluation2)
	//		fmt.Println(nodei,"Total Correct = ", nodecorrecttotal)
	//		fmt.Println(nodei,"Accept Correct = ", nodecorrectaccept)
	//		fmt.Println(nodei,"Accept on Total Correct = ", nodeacceptevaluation)

		}
	}
	//fmt.Println("-------Overall------")
	fmt.Println("total", totalaccept)
	fmt.Println("genuine", genuineaccept)
	overallevaluation1 := float64(genuineaccept)/float64(totalaccept)
	//overallevaluation2 := float64(totalaccept-genuineaccept)/float64(totalaccept)
	overallacceptevaluation := float64(networkcorrectaccept)/float64(networkcorrecttotal)
	fmt.Println("Overall Genuine Acceptance = ", overallevaluation1)
	//fmt.Println("Overall Incorrect Acceptance = ", overallevaluation2)
	fmt.Println("Network Total Correct = ", networkcorrecttotal)
	fmt.Println("Network Accept Correct = ", networkcorrectaccept)
	fmt.Println("Network Accept on Total Correct = ", overallacceptevaluation)
	fmt.Println("End-------------------Trust Model",f,"----------------------End")
}
func main() {
	vars.Sybilvoteoption = 0 //for the sybil nodes voting decision
	fmt.Println("######## Initialization Start ##########")
	_, err := os.Create("initgraph.txt")
	_, err2 := os.Create("graphsessionfinal.txt")
	//for f := 0; f < vars.Nf; f++ {
	for f := 0; f < vars.Nos; f++ {
		filename := "graphsession"+strconv.Itoa(f)+".txt"
		_, err1 := os.Create(filename)
		if err != nil || err1 != nil || err2 != nil {
			fmt.Println("File Creation Error")
		}
	}
	specificnode = ini.Randomrangeint(vars.Mn + vars.Sn + vars.Dn, vars.N)
	autoserviceupdate()
	ini.Resource()
	neighbourallot()
	ini.Nodeinitialize()
	ini.Factinitialize()
	ini.Nodetrustinitialize()
	ini.Scoreinitialize()
	ini.Colludeentryinitialize()
	
	fmt.Println("######## Initialization Completed ##########")
	for i:= 1; i <= vars.N; i++ {
		go nodeactivity(i)
	}
	time.Sleep(vars.Dsecond * time.Second)
	fmt.Println("######## Process Completed ##########")
	finalneighbors("final")

	for f := 0; f < vars.Nf; f++ {
		if vars.Sessionapplicable[f] != 0 {
			resultcompute(f, specificnode)
		}
	}
}
