//======================================================================================
//*************P2M2Sim: A Privacy Preserving Mobility Monitoring Simulator**************
//======================================================================================
//Contributors:S.Venkatesan, Richard Gobel, Yuvaraj Rajendra, Nachiket Tapas, Om Prakash
//Vyas, Sandeep Kumar Shukla, Ranjana Vyas


package main
import (
                "fmt"
                "time"
                "math/rand"
                "os"
                "log"
                "encoding/csv"
		"strconv"
		"strings"
		"sync"
       )
const n = 10 //n - number of individuals
const l = 22  //sn - no of locations-always add one to the location.
const sl = 8 //sl - no of start/end locations //add one to the source location.
const pt = 0.2 // this gives the threshold of privacy. According to this, the jt will be adjusted.
const jt = 3  //join threshold - no of fake nodes for the individual
const st = 4  //stop threshold - no of nodes to stop or kill the fake nodes  
//const service = 3  //Service is required by administrator at this number.  
const lt = 4  //lifetime - lifetime of the fake nodes. It depends on the rounds that is the activity round.  
const act = 4  // activities/round - Maximum number of activities to be performed
const maxconnect = 5 // This is to define how many maximum path a location can have for further movement.
const maxsourceconnect = 5 // This is to define how many maximum path a source location can have
const maxdestinationconnect= 4 // This is to define how many maximum intermediate path a destination location can have
const maxroute = 3 // This is to define how many maximum hops in a route
const storage = 2000 // This is for increasing the storage because of dummies in the middle of the location
const interdummy = 1 // This for introducing dummy node in the middle or not - 0 means no and 1 means yes
var dmatrix[l+sl+sl-2][l+sl+sl-2] int // This is to store how many had come from the same source - without dummy
var smatrix[l+sl+sl-2][l+sl+sl-2] int // This is to store how many goes to the same destination - without dummy
var pmatrix[l+sl+sl-2][l+sl+sl-2] int // This is to store how many are there in the location - without dummy

var ddmatrix[l+sl+sl-2][l+sl+sl-2] int // This is to store how many had come from the same source - with dummy
var dsmatrix[l+sl+sl-2][l+sl+sl-2] int // This is to store how many goes to the same destination - with dummy
var dpmatrix[l+sl+sl-2][l+sl+sl-2] int // This is to store how many are there in the location - with dummy
var ldsmatrix[l+sl+sl-2][l+sl+sl-2][l+sl+sl-2] int // This is to store how many goes to the same (may be as below that is intermediate) destination - with dummy and source labelling
var pldsmatrix[l+sl+sl-2][l+sl+sl-2][l+sl+sl-2] int // This is to store how many goes to the same intermediate destination - with dummy and source labelling
var lsmatrix[l+sl+sl-2][l+sl+sl-2][l+sl+sl-2] int // This is to store how many goes to the same (may be as above that is intermediate) destination - with source labelling

//var pathid[(n+l+sl)*(n+l+sl)] int // This is to store the user movement between the locations. The path between location is identified with an id that is array index.
var routeid[(n+l+sl)*(n+l+sl)][2] int // This is to store the source and destination of each intermediate locations. The path between location is identified with an id that is array index.
var routevisit[(n+l+sl)*(n+l+sl)] int // This is to store the user movement between the locations based on the path id that is the index.
var ndroutevisit[(n+l+sl)*(n+l+sl)] int // This is to store the user movement between the locations based on the path id that is the index without considering the dummy.
var fullpath[l+sl-1][maxconnect*maxconnect+1] int // This is to maintain the complete route map.

var source[n+(jt*storage)+1] int //This is to store the source location of a user or dummy.
var sodes[l+sl+sl-2][l+sl+sl-2] int //This is to store the count from a source to the destination without dummy
var dsodes[l+sl+sl-2][l+sl+sl-2] int //This is to store the count from a source to the destination with dummy
var pdsodes[l+sl+sl-2][l+sl+sl-2] int //This is to store the count from a source to the destination with dummy and probability value

var dprivacy[n+(jt*storage)+1][act] float32 // to store the privacy of the individual at each location without fake nodes - destination
var ddprivacy[n+(jt*storage)+1][act] float32 // to store the privacy of the individual at each location with fake nodes - destination

var sprivacy[n+(jt*storage)+1][act] float32 // to store the privacy of the individual at each location without fake nodes - source
var ssprivacy[n+(jt*storage)+1][act] float32 // to store the privacy of the individual at each location with fake nodes - source

var pprivacy[n+(jt*storage)+1][act] float32 // to store the privacy of the individual at each location without fake nodes - present
var pdprivacy[n+(jt*storage)+1][act] float32 // to store the privacy of the individual at each location with fake nodes - present

var ldsprivacy[n+(jt*storage)+1][act] float32 // to store the privacy of the individual at each location with fake nodes - source and source labelling
//var pldsprivacy[n+(jt*storage)+1][act] float32 // to store the privacy of the individual at each location with fake nodes - probability, source and source labelling
var lsprivacy[n+(jt*storage)+1][act] float32 // to store the privacy of the individual at each location - source and source labelling
var plsprivacy[n+(jt*storage)+1][act] float32 // to store the privacy of the individual at each location - source and source labelling with dummy and probability



var iroutetime[n+(jt*storage)+(n*jt)+(1*jt)][act+2] int // this table is to maintain the visit time of the individual node at a location
var iroute[n+(jt*storage)+(n*jt)+(1*jt)][act+2] int // this table is to maintain the route of the individual node
var irouteround[n+(jt*storage)+(n*jt)+(1*jt)][act+2] int // this table is to maintain the round of route of the individual node

var lpresent[l+sl+sl-2][act][1] int // table to store the total individuals in the location at present
var flpresent[l+sl+sl-2][act][1] int // dead user - table to store the total individuals in the location at present

var table[l+sl+sl-2][act][n+(jt*storage)+(n*jt)] int // table to store the individual movement
var nftable[l+sl+sl-2][act][n+(jt*storage)+(n*jt)] int // table to store the individual movement without fake
var nfatable[l+sl+sl-2][act][n+(jt*storage)+(n*jt)] int // table to store the individual movement without fake and anonymous
var atable[l+sl+sl-2][act][n+(jt*storage)+(n*jt)] int // table to store the individual movement and anonymous
var route[l+sl][maxconnect+1] int // table to store the connections of each intermediate locations. Route table [0] is for number of connects and others are for connections. 
var sconnect[sl][maxsourceconnect+1] int // table to store the source location connected to intermeidate locations. sconnect table [0] is for number of connects and others are for intermediate connections
var dconnect[l+sl][maxdestinationconnect+1] int // table to store the destination location connected to intermeidate locations. dconnect table [0] is for number of connects and others are for intermediate connections
var round int // indicates the round change after 10 second
var starttime int64 // indicates the starting linux time of the simulation in nanoseconds
var pvalue = 4 // indicates the probability value
var idtrack = 1 // helps to mark the identity of the path
var wg sync.WaitGroup //for terminating after all routines completes the job
var sleepsec = 15 //number of seconds to be chosen random 
var sleep1 = time.Duration(15)
var roundsleep1 = time.Duration(20)
type Counter struct {
    mu  sync.Mutex
    routine int
}
func (c *Counter) initialize() {
    c.mu.Lock()
    c.routine = n*(jt+1)
    c.mu.Unlock()
}

func (c *Counter) increment() int {
    c.mu.Lock()
    c.routine += 1
    c.mu.Unlock()
    return c.routine
}

var views Counter
func randomrangeint(from int, to int) int {
        var randno int
        tog := to + 1
        for ; ; {
                rand.Seed(time.Now().UnixNano())
                randno = rand.Intn(tog)
                if randno <= to && randno >= from {
                        break;
                }
        }
        return randno
}

func randomignorevalue(from int, to int, ignore int) int {
        var randno int
        tog := to + 1
        for ; ; {
                rand.Seed(time.Now().UnixNano())
                randno = rand.Intn(tog)
                if randno <= to && randno >= from && randno != ignore{
                        break;
                }
        }
        return randno
}


func routeinitialize() { // This function is to simply initialize the route table
        for i := sl+1; i < sl+l; i++ {
        	for j:= 0; j <= maxconnect; j++ {
			route[i][j] = 0
		}
	}
}
func routeforming() { // This function is to form the route. 
	routeinitialize()
	var exist int 
        for i:= sl; i < sl+l-1; i++ {
		exist = 0 
		m := randomrangeint(1,maxconnect)
        	for j := 1; j <= m; j++ {
			r := randomignorevalue(sl,sl+l-2,i)
			for k := 1; k <= route[i][0]; k++ {
				if route[i][k] == r {
					exist = 1
					break
				}
			}
			if exist == 0 {
				if route[r][0] < maxconnect && route[i][0] < maxconnect { 
					route[i][route[i][0]+1] = r 
					route[r][route[r][0]+1] = i 
					route[i][0]++  
					route[r][0]++  
					routeid[idtrack][0] = i
					routeid[idtrack][1] = r
					idtrack++
					routeid[idtrack][0] = r
					routeid[idtrack][1] = i
					idtrack++

				} else {
					j = j-1;
				} 
			}
		}
	}	
        //for i:= 1; i < idtrack; i++ {
	//	fmt.Println(routeid[i],"\n")
	//}
        for i:= sl; i < sl+l-1; i++ {
		fmt.Println(route[i],"\n")
	}
}

func destinationattach() { // This function attaches the destination with random number of immediate locations or bus stop or others.
	var exist int
	for i := sl; i < sl+l-1; i++ {
		m := randomrangeint(1,maxdestinationconnect) //maxsource connect is used for the destionation source connect
        	for j := 1; j <= m; j++ {
			dlocate := randomrangeint(1,sl-1)
			dlocate = dlocate + sl + l - 2
			exist = 0 
			for k := 1; k <= dconnect[i][0]; k++ {
				if dconnect[i][k] == dlocate {
					exist = 1
					break
				}
			}
			if exist == 0 {
				dconnect[i][dconnect[i][0]+1]  = dlocate 
				dconnect[i][0]++ 
				routeid[idtrack][0] = i
				routeid[idtrack][1] = dlocate
				idtrack++
			} else {
				j = j - 1;
			}
		}
	}
	/*for i := 1; i < sl; i++ {
		for j := 1; j <= sconnect[i][0]; j++ {
			dconnect[sconnect[i][j]][0]++ 
			dconnect[sconnect[i][j]][dconnect[sconnect[i][j]][0]] = i	
			routeid[idtrack][0] = i
			routeid[idtrack][1] = sconnect[i][j]
			idtrack++

		}
	}*/
	for i := sl; i < l+sl-1; i++ {
		fmt.Println(i,":",dconnect[i],"\n")
	}
	for i:= 1; i < idtrack; i++ {
		fmt.Println(routeid[i],"\n")
	}
	for i := 1; i < sl; i++ {
    		for k := 0; k <= sconnect[i][0]; k++ {
                        fullpath[i][k] = sconnect[i][k]
                }
	}
	for j := sl; j < l+sl-1; j++ {
		for k := 0; k <= route[j][0]; k++ {
                        fullpath[j][k] = route[j][k]
                }
	}
	for j := sl; j < l+sl-1; j++ {
		for k := 1; k <= dconnect[j][0]; k++ {
			fullpath[j][0]++
			fullpath[j][fullpath[j][0]] = dconnect[j][k]
		}
	}
	for i:= 1; i < l+sl-1; i++ {
		fmt.Println(i,":",fullpath[i],"\n")
	}
}



func sourceattach() { // This function attaches the source with random number of immediate locations or bus stop or others.
	var exist int
	for i:= 1; i < sl; i++ {
		m := randomrangeint(1,maxsourceconnect)
        	for j := 1; j <= m; j++ {
			slocate := randomrangeint(sl,sl+l-2)
			exist = 0 
			for k := 1; k <= sconnect[i][0]; k++ {
				if sconnect[i][k] == slocate {
					exist = 1
					break
				}
			}
			if exist == 0 {
				sconnect[i][sconnect[i][0]+1]  = slocate 
				sconnect[i][0] ++ 
				routeid[idtrack][0] = i
				routeid[idtrack][1] = slocate
				idtrack++
			} else {
				j = j - 1;
			}
		}
	}
	for i:= 1; i < sl; i++ {
		fmt.Println(sconnect[i],"\n")
	}

}
func enqueue(queue []int, element int) ([]int, int) {
	found := 0
	for _, v := range queue {
      		if v == element {
			found = 1
        		break
      		}
    	}
	if found == 0 {	
		queue = append(queue, element) // Simply append to enqueue.
	}
	//fmt.Println("queue: ",queue, element)
	return queue, found 
}
  
func dequeue(queue []int) (int, []int) {
	if len(queue) == 0 {
		var tmp = []int{}
		return 0, tmp
	
	}
	element := queue[len(queue)-1] // The first element is the one to be dequeued.
	if len(queue) == 1 {
		var tmp = []int{}
		return element, tmp
	} else {
		return element, queue[:len(queue)-1]
	}
}
/*
func enqueue(queue []int, element int) ([]int, int) {
	found := 0
	for _, v := range queue {
      		if v == element {
			found = 1
        		break
      		}
    	}
	if found == 0 {	
		queue = append(queue, element) // Simply append to enqueue.
	}
	fmt.Println("queue: ",queue)
	return queue, found 
}
  
func dequeue(queue []int) (int, []int) {
	if len(queue) == 0 {
		var tmp = []int{}
		return 0, tmp
	
	}
	element := queue[0] // The first element is the one to be dequeued.
	if len(queue) == 1 {
		var tmp = []int{}
		return element, tmp
	} else {
		return element, queue[1:]
	}
}
*/

func privacy(k int, queue []int, level int, levelcount int, usermovcount int, routevisit[(n+l+sl)*(n+l+sl)] int) int {
	var found int
	//fmt.Println("k: ", k,"-",level,"-",levelcount)
	if k <= l + sl -2 && levelcount < level {
		levelcount++
		for j := 1; j <= fullpath[k][0]; j++ {
			//queue, found = enqueue(queue, fullpath[k][j])
			found = 0
			for m := 1; m < idtrack; m++ {
                                if routeid[m][0] == k && routeid[m][1] == fullpath[k][j] {
					if routevisit[m] > 0 {
						usermovcount++
						queue, found = enqueue(queue, fullpath[k][j])
					}
					break
				}
			}
			if found == 1 {
				//fmt.Println("break-queue: ", queue,"--",fullpath[k][j])
				continue
			}
			if k <= l+sl-2 {
				//fmt.Println("ki1: ", k,fullpath[k][j])
				usermovcount = privacy(fullpath[k][j], queue, level, levelcount, usermovcount,routevisit)
				_, queue = dequeue(queue)

			} else {
				break
			}
		}
	}

	_, queue = dequeue(queue)
	return usermovcount
}



func privacytrajectory(i int, routevisit[(n+l+sl)*(n+l+sl)] int) { // This function computes the trajectory privacy of a user.
	var queue = make([]int, 0)
	var levelcount  = 1
	var usermovcount  = 0
	source := iroute[i][1]
	level := iroute[i][0]
	usermovcount = privacy(source,queue,level,levelcount,usermovcount,routevisit)
	if  usermovcount == 0 {
                fmt.Println("Trajectory Leakage of  User ", i, ":", 0, usermovcount)
        } else {
                fmt.Println("Trajectory Leakage of  User ", i, ":", float64(1)/float64(usermovcount), usermovcount)
        }

}

/*func privacytrajectory(i int, routevisit[(n+l+sl)*(n+l+sl)] int) { // This function computes the trajectory privacy of a user.
	var usermovcount = 0
	var queue2 = make([]int, 0)
	var queue = make([]int, 0)
	var queue1 = make([]int, 0)
	var q2 = make([]int, 0)
	source := iroute[i][1]
	level := iroute[i][0]
	var pathlevel = 0
	//var dupcheck [l*l*l] int
	var duprouteid[l*l*l] int
	//var dupchecki = 0
	var duprouteidi = 0
	//var temp = 0
	var temp1 = 0
	var binary = 0
	//fmt.Println("source : ",source)
	for  {
		for j := 1; j <= fullpath[source][0]; j++ {
			for m := 1; m < idtrack; m++ {
	       	       		if routeid[m][0] == source && routeid[m][1] == fullpath[source][j] {
					//if routeid[m][0] == fullpath[source][j] || routeid[m][1] == fullpath[source][j] {
						temp1 = 0
       		         	                if routevisit[m] > 0 {
							for dup := 0; dup < duprouteidi; dup++ {
								if m != duprouteid[dup] {
									temp1++
								} else {
									break
								}
							}
							if temp1 == duprouteidi {
								usermovcount++
								duprouteid[duprouteidi] = m
								duprouteidi++			
							}
							fmt.Println(fullpath[source][0],"----",source,"-",fullpath[source][j],"----",routevisit[m],"--",j,"--",m,"\n")
							//temp = 0
							/*for dup := 0; dup < dupchecki; dup++ {
								if fullpath[source][j] != dupcheck[dup] {
									temp++
								} else {
									break
								}
							}
							if temp == dupchecki {
								//dupcheck[dupchecki] = fullpath[source][j]
								//dupchecki++
								if binary == 0 {
									queue = enqueue(queue, fullpath[source][j])
								} else {
									queue1 = enqueue(queue1, fullpath[source][j])
								}
							//}
						}
        		                        break
					//}
			 	}
       			}
		}
		source, queue = dequeue(queue)
		binary = 1
		//fmt.Println("source : ",source)
		for { 
			if source > l+sl-2{
				source, queue = dequeue(queue)
			} else {
				break
			}
		}
		if source == 0  {   //|| source > l+sl-2{
			q2 = queue
			queue = queue1
			queue1 = q2
			source, queue = dequeue(queue)
			pathlevel++
			if source == 0 || pathlevel == level-1 {	
				break
			}
		}
	}
	if  usermovcount == 0 {
		fmt.Println("Trajectory Leakage of  User ", i, ":", 0, usermovcount)
	} else {
		fmt.Println("Trajectory Leakage of  User ", i, ":", float64(1)/float64(usermovcount), usermovcount)
	}
	//for j := 1; j < idtrack; j++ {
	//	fmt.Println("route visit of",j,": ", routevisit[j])
	//}
}
*/
/*func privacytrajectory(i int, routevisit[(n+l+sl)*(n+l+sl)] int) { // This function computes the trajectory privacy of a user.
        var usermovcount = 0
        var queue = make([]int, 0)
        source := iroute[i][1]
        var dupcheck [l*l*l] int
        level := iroute[i][0]
	var pathlevel = 0
	var duprouteid[l*l*l] int
        var dupchecki = 0
        var duprouteidi = 0
        var temp = 0
        var temp1 = 0
        //fmt.Println("source : ",source)
        for  {
                for j := 1; j <= fullpath[source][0]; j++ {
                        for m := 1; m < idtrack; m++ {
                                if routeid[m][0] == source || routeid[m][1] == source {
                                        if routeid[m][0] == fullpath[source][j] || routeid[m][1] == fullpath[source][j] {
                                                temp1 = 0
                                                if routevisit[m] > 0 {
                                                        for dup := 0; dup < duprouteidi; dup++ {
                                                                if m != duprouteid[dup] {
                                                                        temp1++
                                                                } else {
                                                                        break
                                                                }
                                                        }
                                                        if temp1 == duprouteidi {
                                                                usermovcount++
                                                                duprouteid[duprouteidi] = m
                                                                duprouteidi++
                                                        }
                                                        //fmt.Println(fullpath[source][0],"----",source,"-",fullpath[source][j],"----",routevisit[m],"--",j,"--",m,"\n")
                                                        temp = 0
                                                        for dup := 0; dup < dupchecki; dup++ {
                                                                if fullpath[source][j] != dupcheck[dup] {
                                                                        temp++
                                                                } else {
                                                                        break
                                                                }
                                                        }
                                                        if temp == dupchecki {
                                                                dupcheck[dupchecki] = fullpath[source][j]
                                                                dupchecki++
                                                                queue = enqueue(queue, fullpath[source][j])
                                                        }
                                                }
                                                break
                                        }
                                }
                        }
                }
                source, queue = dequeue(queue)
                //fmt.Println("source : ",source)
                for {
                        if source > l+sl-2{
                                source, queue = dequeue(queue)
                        } else {
                                break
                        }
                }
                if source == 0 || source > l+sl-2{
                        break
                }
        }
        if  usermovcount == 0 {
                fmt.Println("Trajectory Leakage of  User ", i, ":", 0, usermovcount)
        } else {
                fmt.Println("Trajectory Leakage of  User ", i, ":", float64(1)/float64(usermovcount), usermovcount)
        }
        //for j := 1; j < idtrack; j++ {
        //      fmt.Println("route visit of",j,": ", routevisit[j])
        //}
}

*/

func checkrouteid(i int, s int, d int) { //This function maps the individual movement with the route identity and increase the counter of person moving in that that route (between one location to another location no intermeidate location).
	for j := 1; j < idtrack; j++ {
		if routeid[j][0] == s && routeid[j][1] == d {
		//	if routeid[j][0] == d || routeid[j][1] == d {
			fmt.Println("Route Visit",i,"-",s,"-",d,"-",j,"-",routevisit[j],"--",routeid[j][0],"-",routeid[j][1])
				if i <= n {
					ndroutevisit[j] = ndroutevisit[j] + 1
				}
				routevisit[j] = routevisit[j] + 1
				break
		//	}
		}
	}
}


func privacycompute(source1 int, node int, nmove int, destination int) {
        totals := 0.0
        totald := 0.0
        totalp := 0.0
 	dtotals := 0.0
        dtotald := 0.0
        dtotalp := 0.0
        ldstotal := 0.0 //for source labelling with dummy
        lstotal := 0.0 //for source labelling without dummy
        plstotal := 0.0 //for source labelling with dummy and probability
	for jt1 := 1; jt1 < l+sl+sl-2; jt1++ {
		if dsmatrix[source1][jt1] > 0  {
			dtotals =  dtotals + 1.0
		}
		if ddmatrix[destination][jt1] > 0 {
			dtotald =  dtotald + 1.0
		}
		dtotalp = float64(dsmatrix[source1][jt1]) + dtotalp
		if smatrix[source1][jt1] > 0  {
                        totals =  totals + 1.0
                }
                if dmatrix[destination][jt1] > 0 {
                        totald =  totald + 1.0
                }
                totalp = float64(smatrix[source1][jt1]) + totalp
		if ldsmatrix[source1][jt1][source[node]] > 0 {
			ldstotal = ldstotal + 1.0
		}
		if lsmatrix[source1][jt1][source[node]] > 0 {
			lstotal = lstotal + 1.0
		}
		if pldsmatrix[source1][jt1][source[node]] > 0 {
			plstotal = plstotal + 1.0
		}


	}
	dpcomputes := float32(1.0/dtotals)
	dpcomputed := float32(1.0/dtotald)
	dpcomputep := float32(1.0/dtotalp)
	pcomputes := float32(1.0/totals)
        pcomputed := float32(1.0/totald)
        pcomputep := float32(1.0/totalp)
        ldscomputep := float32(1.0/ldstotal)
        lscomputep := float32(1.0/lstotal)
	plscomputep := float32(1.0)
        if plstotal > 0 { 
		plscomputep = float32(1.0/plstotal)
	}
	 
	var dkts, dktd, dktp, kts, ktd, ktp, ldp, lp, plp float32
	if nmove-1 < 0 {
		dkts = 1.0
		dktd = 1.0
		dktp = 1.0
		kts = 1.0
                ktd = 1.0
                ktp = 1.0
                ldp = 1.0 // for source labelling with dummy
                lp = 1.0 // for source labelling without dummy
                plp = 1.0 // for source labelling with dummy and probability

	} else {
		dkts = ssprivacy[node][nmove-1]
		dktd = ddprivacy[node][nmove-1]
		dktp = pdprivacy[node][nmove-1]
		kts = sprivacy[node][nmove-1]
                ktd = dprivacy[node][nmove-1]
                ktp = pprivacy[node][nmove-1]
                ldp = ldsprivacy[node][nmove-1]
                lp = lsprivacy[node][nmove-1]
                plp = plsprivacy[node][nmove-1]

	}
	ssprivacy[node][nmove] = dkts * dpcomputes
	ddprivacy[node][nmove] = dktd * dpcomputed
	pdprivacy[node][nmove] = dktp * dpcomputep
	sprivacy[node][nmove] = kts * pcomputes
        dprivacy[node][nmove] = ktd * pcomputed
        pprivacy[node][nmove] = ktp * pcomputep
        ldsprivacy[node][nmove] = ldp * ldscomputep
        lsprivacy[node][nmove] = lp * lscomputep
        plsprivacy[node][nmove] = plp * plscomputep

//	fmt.Println("Du -Source - Privacy--------",dkts, dpcomputes, node, nmove, ssprivacy[node][nmove])
//	fmt.Println("Du -Destination - Privacy--------",dktd, dpcomputed, node, nmove, ddprivacy[node][nmove])
//	fmt.Println("Du -Present Node - Privacy--------",dktp, dpcomputep, node, nmove, pdprivacy[node][nmove])
//	fmt.Println("Source - Privacy--------",kts, pcomputes, node, nmove, dprivacy[node][nmove])
  //      fmt.Println("Destination - Privacy--------",ktd, pcomputed, node, nmove, dprivacy[node][nmove])
    //    fmt.Println("Present Node - Privacy--------",ktp, pcomputep, node, nmove, dprivacy[node][nmove])
	


}


func linitialize() { //initialize the flpresent matrix for the current user in a location
        for jt1 := 1; jt1 < l+sl+sl-2; jt1++ {
        	for it1 := 0; it1 < round; it1++ {
                        flpresent[jt1][it1][0] = 0
		}
	}
}


func minitialize() { //initialize the count matrix for privacy
        for jt1 := 1; jt1 < l+sl+sl-2; jt1++ {
        	for it1 := 1; it1 < l+sl+sl-2; it1++ {
			smatrix[jt1][it1] = 0
			dmatrix[jt1][it1] = 0
			pmatrix[jt1][it1] = 0
			dsmatrix[jt1][it1] = 0
                        ddmatrix[jt1][it1] = 0
                        dpmatrix[jt1][it1] = 0
        		for kt1 := 1; kt1 < l+sl+sl-2; kt1++ {
				ldsmatrix[jt1][it1][kt1] = 0
				pldsmatrix[jt1][it1][kt1] = 0
				lsmatrix[jt1][it1][kt1] = 0
			}
		}
	}
}

func roundchange(wg *sync.WaitGroup) {  // This function is for the round change
	wg.Done()
	time.Sleep(roundsleep1*time.Second)
	for it := 1; it < act; it++ {
		round = it
		fmt.Println("Round: ",round)
		time.Sleep(roundsleep1*time.Second)
		minitialize()
	}
}
func nextlocation(start int) int { //This function is to find the next location from source
	//fmt.Println(start,"sa")
	if sconnect[start][0] != 0 {
		for k := 1; k < l; k++ {
			next := randomrangeint(1,sconnect[start][0])
			if sconnect[start][next] != 0 {
				return sconnect[start][next]
			}
		}
	}
	return 0
}
func nextintermediatelocation(start int, node int) int { //This function is to find the next location from intermeidate location
	if route[start][0] != 0 {
		for k := sl+1; k < sl+l; k++ {
			next := randomrangeint(1,route[start][0])
			var counter = 0
			if route[start][next] != 0 {
				fmt.Println(node,"------------",next,"------------------")
 				for ri := 1; ri <= iroute[node][0]; ri++ {
				 	if iroute[node][ri] == route[start][next] {
						fmt.Println(node,"----",next, iroute[node],"-------------------")
						break
					} else {
						counter++
					}
				}
				if counter == iroute[node][0] {
					fmt.Println(node,counter,iroute[node][0],"------------",next,"------------------")
					return route[start][next]
				}
			}
		}
	}
	return 0
}

func destination(dest int) int { //This function is to find the destination 
	for k := 1; k < l; k++ {
		next := randomrangeint(1,dconnect[dest][0])
		if dconnect[dest][next] != 0 {
			return dconnect[dest][next]
		}
	}
	return 0
}

func fakenodeactivity(i int, achieve int, roundfake int, asource int, wg *sync.WaitGroup) { // This function initiaes the new person activity
	defer wg.Done()	
	var achieve1 = 0
	//var randno = 0
	var achieve2 = 0
	//var views Counter
	var end = 0
	//fmt.Println("enterssssssssssssssssssssssss",i)
	//if table[achieve][round][0] < st { 
	//fmt.Println("s:",achieve, round, table[achieve][round][0])
	table[achieve][round][table[achieve][round][0]+1] = i
        table[achieve][round][0]++

	atable[achieve][round][atable[achieve][round][0]+1] = 1
        atable[achieve][round][0]++
	source[i] = asource
	flpresent[achieve][round][0]++
	fmt.Println("enter---",flpresent[achieve][round][0])
	//fmt.Println("route",i)
	//fmt.Println("route",i, iroute[i][0])
	iroute[i][0]++
        iroute[i][iroute[i][0]] = achieve
        fmt.Println(i,"iroute-----------------------", iroute[i][iroute[i][0]])
        irouteround[i][0]++
        irouteround[i][irouteround[i][0]] = round
	

	time.Sleep(sleep1*time.Second)
	//fmt.Println("sa:",achieve)
	if(achieve > sl-1) {
		achieve2 = nextintermediatelocation(achieve, i)
	} else {
		achieve2 = nextlocation(achieve)
	}
	if achieve2 != 0 {
		table[achieve2][round][table[achieve2][round][0]+1] = i
		table[achieve2][round][0]++

		atable[achieve2][round][atable[achieve2][round][0]+1] = 1
                atable[achieve2][round][0]++
		
		flpresent[achieve][round][0]--
		if flpresent[achieve][round][0] < 0  { flpresent[achieve][round][0] = 0 }
		flpresent[achieve2][round][0]++

	        //fmt.Println("route",i, iroute[i][0])
		iroute[i][0]++
                iroute[i][iroute[i][0]] = achieve2
        	fmt.Println(i,"d2-----------------------", iroute[i][iroute[i][0]])
                
		irouteround[i][0]++
                irouteround[i][irouteround[i][0]] = round

		dsmatrix[achieve][achieve2] =  dsmatrix[achieve][achieve2] + 1
		ddmatrix[achieve2][achieve] =  ddmatrix[achieve2][achieve] + 1 
		
		ldsmatrix[achieve][achieve2][source[i]] = ldsmatrix[achieve][achieve2][source[i]] + 1
		contribute1 := randomrangeint(1,pvalue)
                cvalue1 := 0
                if (contribute1 > 1) {
                	cvalue1 = 0
                } else {
	                cvalue1 = 1
                }
		pldsmatrix[achieve][achieve2][source[i]] = pldsmatrix[achieve][achieve2][source[i]] + cvalue1
		
		checkrouteid(i,achieve,achieve2)			
		achieve = achieve2 

	}
	//} else {
	//	fmt.Println("fake kill:",i)	
	//	end = 1	
	//}
	//fmt.Println(end)
	fi := 0
	for k := 1; k < act; k++ {
		//time.Sleep(sleep1*time.Second)
		rand.Seed(time.Now().UnixNano())
                randno := rand.Intn(sleepsec)
		time.Sleep(time.Duration(randno) * time.Second)


		var proceed = 0
		var added = 0
		decide := randomrangeint(1,5)

		//if flpresent[achieve][round][0] < st && (round-roundfake) <= lt { 
		if flpresent[achieve][round][0] < st && iroute[i][0] <= lt { 
			if decide == 1 && end == 0 {  //destination to reach
			
				rand.Seed(time.Now().UnixNano())
                		randno = rand.Intn(10)
				if flpresent[achieve][round][0] < jt + 1 && randno == 1{ //introducing dummy if less than the threshold
		                        if interdummy > 0 {
						for fi = 1; fi <= jt - flpresent[achieve][round][0]; fi++ {
                	                		//fmt.Println("dummytodummy",i,fi+routine,achieve)
							//rand.Seed(time.Now().UnixNano())
       		                                 	//randno := rand.Intn(5)
               		                         	//time.Sleep(time.Duration(randno) * time.Second)
							val := views.increment();
							fmt.Println(fi,"enterssssssssssssssssssssssss",i,val, jt, flpresent[achieve][round][0])
   							wg.Add(1)
							go fakenodeactivity(val,achieve,round,source[i], wg)
                        			        //go fakenodeactivity(fi+routine,achieve,round)
                        			}
					}
		                        //routine = routine + fi -1
					added = 1;
               			}
				dest := destination(achieve)
				if dest != 0 {
					table[dest][round][table[dest][round][0]+1] = i
					table[dest][round][0]++

					atable[dest][round][atable[dest][round][0]+1] = 1
                                        atable[dest][round][0]++

					flpresent[achieve][round][0]--
					if flpresent[achieve][round][0] < 0  { flpresent[achieve][round][0] = 0 }
					flpresent[dest][round][0]++

	                                //fmt.Println("d-route",i, iroute[i][0],k)
					iroute[i][0]++

                                	iroute[i][iroute[i][0]] = dest
					
        				//fmt.Println(i,"d3-----------------------", iroute[i][iroute[i][0]])
					//fmt.Println(i, dest,"-------------------------------destination")
	                                irouteround[i][0]++
        	                        irouteround[i][irouteround[i][0]] = round

					dsmatrix[achieve][dest] =  dsmatrix[achieve][dest] + 1
					ddmatrix[dest][achieve] =  ddmatrix[dest][achieve] + 1
					ldsmatrix[achieve][dest][source[i]] = ldsmatrix[achieve][dest][source[i]] + 1

					contribute1 := randomrangeint(1,pvalue)
                			cvalue1 := 0
			                if (contribute1 > 1) {
				                cvalue1 = 0
			                } else {
				                cvalue1 = 1
			                }
					pldsmatrix[achieve][dest][source[i]] = pldsmatrix[achieve][dest][source[i]] + cvalue1
					
					checkrouteid(i,achieve,dest)			
					contribute := randomrangeint(1,pvalue)
                                        cvalue := 0
					if (contribute > 1) {
                                                cvalue = 0
                                        } else {
                                                cvalue = 1
                                        }
					dsodes[dest][source[i]] = dsodes[dest][source[i]] + 1 //cvalue 
					pdsodes[dest][source[i]] = pdsodes[dest][source[i]] + cvalue 
					end = 1
					fmt.Println(cvalue)
				} else {
					proceed = 1
				}
			} else {
				proceed = 1
			}
			if proceed == 1 && end == 0 {
			//fmt.Println(achieve,round,k,i)
				rand.Seed(time.Now().UnixNano())
                		randno = rand.Intn(10)
				if flpresent[achieve][round][0] < jt + 1 && added == 0 && randno ==  1 {
		                        if interdummy > 0 {
                                        	for fi = 1; fi <= jt - flpresent[achieve][round][0]; fi++ {
                                               		//fmt.Println("dummytodummy",i,fi+routine,achieve)
	                                                //rand.Seed(time.Now().UnixNano())
        	                                	//randno := rand.Intn(10)
	       		                                 //time.Sleep(time.Duration(randno) * time.Second)
							val := views.increment();
							fmt.Println(fi,"denterssssssssssssssssssssssss",i,val, jt, flpresent[achieve][round][0])
							//fmt.Println("enterssssssssssssssssssssssss",i,fi+routine)
							wg.Add(1)
							go fakenodeactivity(val,achieve,round,source[i], wg)
                        	                }
					}
                                        //routine = routine + fi -1
                                }
				added = 0
				achieve1 = nextintermediatelocation(achieve, i)
				if achieve1 != 0 {
					//fmt.Println(achieve1, round, table[achieve1][round][0])
					table[achieve1][round][table[achieve1][round][0]+1] = i
					table[achieve1][round][0]++
					
					atable[achieve1][round][atable[achieve1][round][0]+1] = 1
                                        atable[achieve1][round][0]++

					flpresent[achieve][round][0]--
					if flpresent[achieve][round][0] < 0  { flpresent[achieve][round][0] = 0 }
					fmt.Println("Achieve",achieve1, achieve,flpresent[achieve][round][0])
					flpresent[achieve1][round][0]++
					
	                                //fmt.Println("a-route",i, iroute[i][0],k)
					iroute[i][0]++

					iroute[i][iroute[i][0]] = achieve1
        				fmt.Println(i,"d4-----------------------", iroute[i][iroute[i][0]])
                                	
					irouteround[i][0]++
	                                irouteround[i][irouteround[i][0]] = round

					dsmatrix[achieve][achieve1] =  dsmatrix[achieve][achieve1] + 1
					ddmatrix[achieve1][achieve] =  ddmatrix[achieve1][achieve] + 1
					
					ldsmatrix[achieve][achieve1][source[i]] = ldsmatrix[achieve][achieve1][source[i]] + 1
					fmt.Println(i,achieve1, "-------------------------------", ldsmatrix[achieve][achieve1])
					contribute1 := randomrangeint(1,pvalue)
                			cvalue1 := 0
			                if (contribute1 > 1) {
				                cvalue1 = 0
			                } else {
				                cvalue1 = 1
			                }
					pldsmatrix[achieve][achieve1][source[i]] = pldsmatrix[achieve][achieve1][source[i]] + cvalue1
					
					checkrouteid(i,achieve,achieve1)			
					rand.Seed(time.Now().UnixNano())
                                	randno = rand.Intn(2)
	                                if randno == 1 {
        	                                time.Sleep(sleep1*time.Second)
						contribute := randomrangeint(1,pvalue)
                                        	cvalue := 0
	                                        if (contribute > 1) {
        	                                        cvalue = 0
                	                        } else {
                       	        	                cvalue = 1
                       		                }
                	                        dsodes[achieve1][source[i]] = dsodes[achieve1][source[i]] + 1
                	                        pdsodes[achieve1][source[i]] = pdsodes[achieve1][source[i]] + cvalue
                        	                source[i] = achieve1
	                                }
	
					achieve = achieve1

					
					//break
				}
			} else {
				fmt.Println("fake stop:",i)
				end = 1	
			}
		} else {
			fmt.Println("fake kill:",i)	
			end = 1	
		}
	}
}

func nodeactivity(i int, wg *sync.WaitGroup) { // This function initiaes the new person activity
	defer wg.Done()	
	var achieve = 0
	//var randno = 0
	//var views Counter
	var achieve1 = 0
	for j := 1; j < l; j++ {
		start := randomrangeint(1,sl-1)
		//fmt.Println("aa:",start,round,table[start][round][0])
		table[start][round][table[start][round][0]+1] = i
		table[start][round][0]++
		atable[start][round][atable[start][round][0]+1] = 1
                atable[start][round][0]++

		nftable[start][round][nftable[start][round][0]+1] = i
                nftable[start][round][0]++
                nfatable[start][round][nfatable[start][round][0]+1] = 1
                nfatable[start][round][0]++
		
		source[i] = start	


		presenttime := time.Now().Unix()
		fmt.Println(presenttime, starttime)
		timediff := int(presenttime - starttime)
		fmt.Println(timediff)
		//os.Exit(0)
		iroutetime[i][0]++
		iroutetime[i][iroutetime[i][0]] = timediff 

		iroute[i][0]++
                iroute[i][iroute[i][0]] = start

                irouteround[i][0]++
                irouteround[i][irouteround[i][0]] = round

	
		lpresent[start][round][0]++
		flpresent[start][round][0]++
		fmt.Println("begin---a",flpresent[start][round][0])
		lcompute := (n+1)+(i*jt) // for the fake nodes introduction
		for fi := lcompute-jt; fi < lcompute; fi++ {
			fmt.Println("ssssssssssssssssssssss",i,fi)
			wg.Add(1)
			go fakenodeactivity(fi,start,round,source[i],wg)
		}
		


		achieve = nextlocation(start)
		if achieve != 0 {
			//fmt.Println("kk:",achieve,round,table[achieve][round][0])
			table[achieve][round][table[achieve][round][0]+1] = i
			table[achieve][round][0]++
			
			atable[achieve][round][atable[achieve][round][0]+1] = 1
                        atable[achieve][round][0]++
		
			nftable[achieve][round][nftable[achieve][round][0]+1] = i
                        nftable[achieve][round][0]++

                        nfatable[achieve][round][nfatable[achieve][round][0]+1] = 1
                        nfatable[achieve][round][0]++

			flpresent[achieve][round][0]++
			flpresent[start][round][0]--
			if flpresent[start][round][0] < 0  { flpresent[start][round][0] = 0 }

			lpresent[achieve][round][0]++
			lpresent[start][round][0]--
			if lpresent[start][round][0] < 0  { lpresent[start][round][0] = 0 }
			fmt.Println("begin---b",flpresent[achieve][round][0])
			
			presenttime := time.Now().Unix()
                	timediff := int(presenttime - starttime)
                	iroutetime[i][0]++
                	iroutetime[i][iroutetime[i][0]] = timediff

			iroute[i][0]++
	                iroute[i][iroute[i][0]] = achieve

        	        irouteround[i][0]++
               		irouteround[i][irouteround[i][0]] = round

			dsmatrix[start][achieve] =  dsmatrix[start][achieve]+1 
			ddmatrix[achieve][start] =  ddmatrix[achieve][start]+1 
			
			smatrix[start][achieve] =  smatrix[start][achieve]+1
                        dmatrix[achieve][start] =  dmatrix[achieve][start]+1

			ldsmatrix[start][achieve][source[i]] = ldsmatrix[start][achieve][source[i]] + 1 
			lsmatrix[start][achieve][source[i]] = lsmatrix[start][achieve][source[i]] + 1 
			contribute1 := randomrangeint(1,pvalue)
                	cvalue1 := 0
		        if (contribute1 > 1) {
		        	cvalue1 = 1
		        } else {
		        	cvalue1 = 0
		        }
			pldsmatrix[start][achieve][source[i]] = pldsmatrix[start][achieve][source[i]] + cvalue1 
		
			checkrouteid(i,start,achieve)			

			privacycompute(start, i, 0, achieve) 

			break
		}
  	}
	var end = 0
	//fmt.Println(end) 
	fi1 := 0
	added := 0
	for k := 1; k < act; k++ {

		var proceed = 0
		
		//time.Sleep(sleep1*time.Second)
		rand.Seed(time.Now().UnixNano())
                randno := rand.Intn(sleepsec)
		time.Sleep(time.Duration(randno) * time.Second)

		decide := randomrangeint(1,5)

		if decide == 1 && end == 0 {  //destination to reach
			rand.Seed(time.Now().UnixNano())
                	randno = rand.Intn(10)
			if flpresent[achieve][round][0] < jt + 1 && randno == 1{
		                if interdummy > 0 {
                        		for fi1 = 1; fi1 <= jt - flpresent[achieve][round][0]; fi1++ {
                        			//fmt.Println("dummyintheintermediate",i,fi1+routine)
                               		 	//rand.Seed(time.Now().UnixNano())
                				//randno := rand.Intn(5)
			       		         //time.Sleep(time.Duration(randno) * time.Second)
						val := views.increment();
						fmt.Println("ssssssssssssssssssssss",i,val)
						//go fakenodeactivity(fi1+routine,achieve,round)
						wg.Add(1)
						go fakenodeactivity(val,achieve,round,source[i],wg)
                       		 	}
				}
                        	//routine = routine + fi1 -1
				added = 1
        	        }
	
			dest := destination(achieve)
			if dest != 0 {
				atable[dest][round][atable[dest][round][0]+1] = 1
                                atable[dest][round][0]++

				table[dest][round][table[dest][round][0]+1] = i
				table[dest][round][0]++

				nfatable[dest][round][nfatable[dest][round][0]+1] = 1
                                nfatable[dest][round][0]++

                                nftable[dest][round][nftable[dest][round][0]+1] = i
                                nftable[dest][round][0]++
	
				flpresent[achieve][round][0]--
				if flpresent[achieve][round][0] < 0  { flpresent[achieve][round][0] = 0 }
                                flpresent[dest][round][0]++
			
				lpresent[achieve][round][0]--
				if lpresent[achieve][round][0] < 0  { lpresent[achieve][round][0] = 0 }
				lpresent[dest][round][0]++
				
				presenttime := time.Now().Unix()
                        	timediff := int(presenttime - starttime)
	                        iroutetime[i][0]++
	                        iroutetime[i][iroutetime[i][0]] = timediff


				fmt.Println("begin---d",achieve,flpresent[achieve][round][0])
				iroute[i][0]++
                		iroute[i][iroute[i][0]] = dest

		                irouteround[i][0]++
		                irouteround[i][irouteround[i][0]] = round

				dsmatrix[achieve][dest] =  dsmatrix[achieve][dest] + 1
				ddmatrix[dest][achieve] =  ddmatrix[dest][achieve] + 1
				
				smatrix[achieve][dest] =  smatrix[achieve][dest] + 1
                                dmatrix[dest][achieve] =  dmatrix[dest][achieve] + 1
				ldsmatrix[achieve][dest][source[i]] = ldsmatrix[achieve][dest][source[i]] + 1
				lsmatrix[achieve][dest][source[i]] = lsmatrix[achieve][dest][source[i]] + 1
				contribute1 := randomrangeint(1,pvalue)
                		cvalue1 := 0
			        if (contribute1 > 1) {
			        	cvalue1 = 1
			        } else {
			        	cvalue1 = 0
			        }
				pldsmatrix[achieve][dest][source[i]] = pldsmatrix[achieve][dest][source[i]] + cvalue1
			
				checkrouteid(i,achieve,dest)			

				privacycompute(achieve, i, k, dest) 
				contribute := randomrangeint(1,pvalue)
                                cvalue := 0
				if (contribute > 1) {
					cvalue = 1
				} else {
					cvalue = 0
				}
				sodes[dest][source[i]] = sodes[dest][source[i]] + 1 // cvalue 
				dsodes[dest][source[i]] = dsodes[dest][source[i]] + 1 //cvalue
				pdsodes[dest][source[i]] = pdsodes[dest][source[i]] + cvalue
				fmt.Println(cvalue)
				end = 1
			} else {
				proceed = 1
			}
		} else {
			proceed = 1
		}
		if proceed == 1 && end == 0 {
		//fmt.Println(achieve,round,k,i)


			rand.Seed(time.Now().UnixNano())
                	randno = rand.Intn(10)
			if flpresent[achieve][round][0] < jt + 1 && added == 0 && randno == 1 {
		               if interdummy > 0 {
                               		for fi1 = 1; fi1 <= jt - flpresent[achieve][round][0]; fi1++ {
						//fmt.Println("dummyintheintermediate",i,fi1+routine)
						//rand.Seed(time.Now().UnixNano())
       		                                 //randno := rand.Intn(5)
       		                                 //time.Sleep(time.Duration(randno) * time.Second)
						val := views.increment();
						fmt.Println("ssssssssssssssssssssss",i,val)
						//go fakenodeactivity(fi1+routine,achieve,round)
						wg.Add(1)
						go fakenodeactivity(val,achieve,round,source[i],wg)
       		                        }
				}
                                //routine = routine + fi1 - 1
                       	}
			added = 0
			achieve1 = nextintermediatelocation(achieve, i)
			if achieve1 != 0 {
				table[achieve1][round][table[achieve1][round][0]+1] = i
				table[achieve1][round][0]++
				
				atable[achieve1][round][atable[achieve1][round][0]+1] = 1
                                atable[achieve1][round][0]++
				
				nftable[achieve1][round][nftable[achieve1][round][0]+1] = i
                                nftable[achieve1][round][0]++

                                nfatable[achieve1][round][nfatable[achieve1][round][0]+1] = 1
                                nfatable[achieve1][round][0]++

				lpresent[achieve][round][0]--
				if lpresent[achieve][round][0] < 0  { lpresent[achieve][round][0] = 0 }
				lpresent[achieve1][round][0]++
				
				flpresent[achieve][round][0]--
				if flpresent[achieve][round][0] < 0  { flpresent[achieve][round][0] = 0 }
                                flpresent[achieve1][round][0]++

				presenttime := time.Now().Unix()
                        	timediff := int(presenttime - starttime)
	                        iroutetime[i][0]++
	                        iroutetime[i][iroutetime[i][0]] = timediff

				fmt.Println("begin---z",flpresent[achieve][round][0])
				iroute[i][0]++
                		iroute[i][iroute[i][0]] = achieve1

		                irouteround[i][0]++
		                irouteround[i][irouteround[i][0]] = round

				dsmatrix[achieve][achieve1] =  dsmatrix[achieve][achieve1] + 1
				ddmatrix[achieve1][achieve] =  ddmatrix[achieve1][achieve] + 1

				smatrix[achieve][achieve1] =  smatrix[achieve][achieve1] + 1
                                dmatrix[achieve1][achieve] =  dmatrix[achieve1][achieve] + 1
				
				ldsmatrix[achieve][achieve1][source[i]] = ldsmatrix[achieve][achieve1][source[i]] + 1
				lsmatrix[achieve][achieve1][source[i]] = lsmatrix[achieve][achieve1][source[i]] + 1
				contribute1 := randomrangeint(1,pvalue)
                		cvalue1 := 0
			        if (contribute1 > 1) {
			        	cvalue1 = 1
			        } else {
			        	cvalue1 = 0
			        }
				pldsmatrix[achieve][achieve1][source[i]] = pldsmatrix[achieve][achieve1][source[i]] + cvalue1
				checkrouteid(i,achieve,achieve1)			
				privacycompute(achieve, i, k, achieve1) 
				rand.Seed(time.Now().UnixNano())
                		randno = rand.Intn(2)
				if randno == 1 {
					time.Sleep(sleep1*time.Second)
					contribute := randomrangeint(1,pvalue)
                                        cvalue := 0
					if (contribute > 1) {
						cvalue = 1
					} else {
						cvalue = 0
					}
					sodes[achieve1][source[i]] = sodes[achieve1][source[i]] + 1 
					dsodes[achieve1][source[i]] = dsodes[achieve1][source[i]] + 1 
					pdsodes[achieve1][source[i]] = pdsodes[achieve1][source[i]] + cvalue 
					source[i] = achieve1
				}
				
				achieve = achieve1
				//break
			}
		} else {
			fmt.Println("stop:",i)	
			end = 1
		}
	}
}

func test() {
	for i := 1; i < 100;  i++ {
		
	}
}

func main() {
        

	views.initialize()
	linitialize()
	fmt.Println("######## Source Attach to Inbetween Stops ##########")
        sourceattach()
	//os.Exit(0)
	fmt.Println("######## Route Formation (Network of Inbetween Stops) ##########")
        //_, err := os.Create("graph.txt")
        routeforming()
        //fmt.Println("######## Source Attach to Inbetween Stops ##########")
        //sourceattach()
        fmt.Println("######## Destination Attach from Inbetween Stops ##########")
        destinationattach()
        fmt.Println("######## Activities Started ##########")
	starttime = time.Now().Unix()
   	wg.Add(n+1)
        go roundchange(&wg)
        for i:= 1; i <= n; i++ {
        	//rand.Seed(time.Now().UnixNano())
                randno := rand.Intn(4)
		time.Sleep(time.Duration(randno) * time.Second)
                go nodeactivity(i, &wg)
        }
        //time.Sleep(act*8*time.Second)

	wg.Wait()
	//close(messages)
	fmt.Println("######## Process Completed ##########")
        fmt.Println("######## Output without Dead Node ##########")
	fmt.Println("######## Final Result: Users at Starting locations in various rounds ##########")
        for j := 1; j < sl; j++ {
                fmt.Println("Location ",j,":",nftable[j])
        }
        fmt.Println("######## Final Result: Users at various locations in various rounds ##########")
        for j := sl; j < l+sl-1; j++ {
                fmt.Println("Location ",j,":",nftable[j])
        }
        fmt.Println("######## Final Result: Users at the Destination in various rounds ##########")
        for j := l+sl-1; j < l+sl+sl-2; j++ {
                fmt.Println("Location ",j,":",nftable[j])
        }
        
	fmt.Println("######## Output with Dead Node ##########")
        fmt.Println("######## Final Result: Users at Starting locations in various rounds ##########")
        for j := 1; j < sl; j++ {
                fmt.Println("Location ",j,":",table[j])
        }
        fmt.Println("######## Final Result: Users at various locations in various rounds ##########")
        for j := sl; j < l+sl-1; j++ {
                fmt.Println("Location ",j,":",table[j])
        }
        fmt.Println("######## Final Result: Users at the Destination in various rounds ##########")
        for j := l+sl-1; j < l+sl+sl-2; j++ {
                fmt.Println("Location ",j,":",table[j])
        }


	fmt.Println("######## Output without Dead Node ##########")
	var IDs6[sl+l+sl-2][] string
        var str string
        fmt.Println("######## Final Result: Users at Starting locations in various rounds ##########")
        for j:= 1; j < sl; j++ {
                fmt.Print("Location ",j,":")
                for k:= 0; k < act; k++ {
                        fmt.Print("Round ",k,":")
	      		str = ""
                        for i:= 1; i <= nftable[j][k][0]; i++ {
                                fmt.Print(nftable[j][k][i])
				str = str +" " + strconv.Itoa(nftable[j][k][i])
                        }
    			IDs6[j] = append(IDs6[j], str)
                        fmt.Print("     ")
                }
                        fmt.Print("\n")
        }
        fmt.Println("######## Final Result: Users at various locations in various rounds ##########")
        for j:= sl; j < sl+l+sl-2; j++ {
                fmt.Print("Location ",j,":")
                for k:= 0; k < act; k++ {
                        fmt.Print("Round ",k,":")
	      		str = ""
                        for i := 1; i <= nftable[j][k][0]; i++ {
                                fmt.Print(nftable[j][k][i])
				str = str +" " + strconv.Itoa(nftable[j][k][i])
                        }
    			IDs6[j] = append(IDs6[j], str)
                        fmt.Print("     ")
                }
                fmt.Print("\n");
                if(j == sl+l-2) {
                        fmt.Println("######## Final Result: Users at Destination locations in various rounds ##########")
                }
        }

	csvFile, err := os.Create("location-real.csv")
        if err != nil {
                log.Fatalf("failed creating file: %s", err)
        }
        csvwriter := csv.NewWriter(csvFile)
        for o := 1; o < sl+l+sl-2; o++ {
                _ = csvwriter.Write(IDs6[o])
        }
        csvwriter.Flush()
        csvFile.Close()


        fmt.Print("\n");
	var IDs5[sl+l+sl-2][] string
	fmt.Println("######## Output with Dead Node (Anonymized) ##########")
        fmt.Println("######## Final Result: Users at Starting locations in various rounds ##########")
        for j:= 1; j < sl; j++ {
                fmt.Print("Location ",j,":")
	      	for k:= 0; k < act; k++ {
                	fmt.Print("Round ",k,":")
	      		str = ""
			for i:= 1; i <= table[j][k][0]; i++ {
				fmt.Print(table[j][k][i])
				str = str +" " + strconv.Itoa(table[j][k][i])
			}
    			IDs5[j] = append(IDs5[j], str)
			fmt.Print("	")
		}
			fmt.Print("\n")
        }
        

	fmt.Println("######## Final Result: Users at various locations in various rounds ##########")
	for j:= sl; j < sl+l+sl-2; j++ {
                fmt.Print("Location ",j,":")
	      	for k:= 0; k < act; k++ {
			str = ""
                	fmt.Print("Round ",k,":")
	      		for i := 1; i <= table[j][k][0]; i++ {
				fmt.Print(table[j][k][i])
				str = str +" " + strconv.Itoa(table[j][k][i])
			}
    			IDs5[j] = append(IDs5[j], str)
			fmt.Print("	")
		}
		fmt.Print("\n");
		if(j == sl+l-2) {
        		fmt.Println("######## Final Result: Users at Destination locations in various rounds ##########")
		}
        }

	csvFile, err = os.Create("locationfake-real.csv")
        if err != nil {
                log.Fatalf("failed creating file: %s", err)
        }
        csvwriter = csv.NewWriter(csvFile)
        for o := 1; o < sl+l+sl-2; o++ {
                _ = csvwriter.Write(IDs5[o])
        }
        csvwriter.Flush()
        csvFile.Close()



  	fmt.Println("######## Output without Dead Node (Anonymized) ##########")
        fmt.Println("######## Final Result: Users at Starting locations in various rounds ##########")
        for j:= 1; j < sl; j++ {
                fmt.Println("Location ",j,":",nfatable[j])
        }
        fmt.Println("######## Final Result: Users at various locations in various rounds ##########")
        for j:= sl; j < l+sl-1; j++ {
                fmt.Println("Location ",j,":",nfatable[j])
        }
        fmt.Println("######## Final Result: Users at the Destination in various rounds ##########")
        for j := l+sl-1; j < l+sl+sl-2; j++ {
                fmt.Println("Location ",j,":",nfatable[j])
        }

  	fmt.Println("######## Output with Dead Node (Anonymized) ##########")
        fmt.Println("######## Final Result: Users at Starting locations in various rounds ##########")
        for j:= 1; j < sl; j++ {
                fmt.Println("Location ",j,":",atable[j])
        }
        fmt.Println("######## Final Result: Users at various locations in various rounds ##########")
        for j:= sl; j < l+sl-1; j++ {
                fmt.Println("Location ",j,":",atable[j])
        }
        fmt.Println("######## Final Result: Users at the Destination in various rounds ##########")
        for j:= l+sl-1; j < l+sl+sl-2; j++ {
                fmt.Println("Location ",j,":",atable[j])
        }

	fmt.Println("######## Output without Dead Node (Anonymized) ##########")
	var IDs4[sl+l+sl-2][] string
        fmt.Println("######## Final Result: Users at Starting locations in various rounds ##########")
        for j:= 1; j < sl; j++ {
                fmt.Print("Location ",j,":")
                for k:= 0; k < act; k++ {
                        fmt.Print("Round ",k,":")
	      		str = ""
                        for i:= 1; i <= nfatable[j][k][0]; i++ {
                                fmt.Print(nfatable[j][k][i])
				str = str + strconv.Itoa(nfatable[j][k][i])
                        }
    			IDs4[j] = append(IDs4[j], str)
                        fmt.Print("     ")
                }
                        fmt.Print("\n")
        }
        fmt.Println("######## Final Result: Users at various locations in various rounds ##########")
        for j:= sl; j < sl+l+sl-2; j++ {
                fmt.Print("Location ",j,":")
                for k:= 0; k < act; k++ {
                        fmt.Print("Round ",k,":")
	      		str = ""
                        for i := 1; i <= nfatable[j][k][0]; i++ {
                                fmt.Print(nfatable[j][k][i])
				str = str + strconv.Itoa(nfatable[j][k][i])
                        }
    			IDs4[j] = append(IDs4[j], str)
                        fmt.Print("     ")
                }
                fmt.Print("\n");
                if(j == sl+l-2) {
                        fmt.Println("######## Final Result: Users at Destination locations in various rounds ##########")
                }
        }

	csvFile, err = os.Create("location.csv")
        if err != nil {
                log.Fatalf("failed creating file: %s", err)
        }
        csvwriter = csv.NewWriter(csvFile)
        for o := 1; o < sl+l+sl-2; o++ {
                _ = csvwriter.Write(IDs4[o])
        }
        csvwriter.Flush()
        csvFile.Close()


        fmt.Print("\n");
	var IDs3[sl+l+sl-2][] string
	fmt.Println("######## Output with Dead Node (Anonymized) ##########")
        fmt.Println("######## Final Result: Users at Starting locations in various rounds ##########")
        for j:= 1; j < sl; j++ {
                fmt.Print("Location ",j,":")
	      	for k:= 0; k < act; k++ {
                	fmt.Print("Round ",k,":")
	      		str = ""
			for i:= 1; i <= atable[j][k][0]; i++ {
				fmt.Print(atable[j][k][i])
				str = str + strconv.Itoa(atable[j][k][i])
			}
    			IDs3[j] = append(IDs3[j], str)
			fmt.Print("	")
		}
			fmt.Print("\n")
        }
        

	fmt.Println("######## Final Result: Users at various locations in various rounds ##########")
	for j:= sl; j < sl+l+sl-2; j++ {
                fmt.Print("Location ",j,":")
	      	for k:= 0; k < act; k++ {
			str = ""
                	fmt.Print("Round ",k,":")
	      		for i := 1; i <= atable[j][k][0]; i++ {
				fmt.Print(atable[j][k][i])
				str = str + strconv.Itoa(atable[j][k][i])
			}
    			IDs3[j] = append(IDs3[j], str)
			fmt.Print("	")
		}
		fmt.Print("\n");
		if(j == sl+l-2) {
        		fmt.Println("######## Final Result: Users at Destination locations in various rounds ##########")
		}
        }

	csvFile, err = os.Create("locationfake.csv")
        if err != nil {
                log.Fatalf("failed creating file: %s", err)
        }
        csvwriter = csv.NewWriter(csvFile)
        for o := 1; o < sl+l+sl-2; o++ {
                _ = csvwriter.Write(IDs3[o])
        }
        csvwriter.Flush()
        csvFile.Close()



        fmt.Println("######## Final Result: Users Route at various rounds ##########")
	for j:= 1; j <= n+n; j++ {
		fmt.Println("User",j)
		fmt.Println(iroute[j])
		fmt.Println(irouteround[j])
	}
        var path [n+n+1][act+1][] string
	for j:= 0; j < act; j++ {
		for i:= 1; i <= n+n; i++ {
			for k:= 1; k < act+2; k++ {
				if irouteround[i][k] == j {
					if iroute[i][k] != 0 {
						//fmt.Print(iroute[i][k])
    						//path[i][j] = append(path[i][j], strconv.Itoa(iroute[i][k]))
    						//fmt.Println(i,j,k)
						path[i][j] = append(path[i][j], strconv.Itoa(iroute[i][k]))
					}
				}
			}
			//fmt.Print("\n")
		}
		//fmt.Print("\n")
	}
	csvFile, err = os.Create("route.csv")
        if err != nil {
                log.Fatalf("failed creating file: %s", err)
        }
        csvwriter = csv.NewWriter(csvFile)
	var pathstring string
        var IDs12[n+n+2][] string
        //var pathstring1 [n+n+2][100] string
        for i:= 1; i <= n+n; i++ {
                for j:= 0; j < act; j++ {
                        pathstring = strings.Join(path[i][j]," ")
                        IDs12[i] = append(IDs12[i], pathstring)
                        //fmt.Println(path[i][j])

                }

                        //path[i][j] = strings.Replace(pathstring, ",", "|", act)
        }
        for o := 1; o <= n+n; o++ {
                _ = csvwriter.Write(IDs12[o])
        }


        csvwriter.Flush()
        csvFile.Close()


	
	fmt.Println("######## Final Result: Users Route time at various rounds ##########")
        var path1 [n+n+1][act+1][] string
	for j:= 0; j < act; j++ {
		for i:= 1; i <= n+n; i++ {
			for k:= 1; k < act+2; k++ {
				if irouteround[i][k] == j {
					if iroutetime[i][k] != 0 {
						//fmt.Print(iroute[i][k])
    						//path[i][j] = append(path[i][j], strconv.Itoa(iroute[i][k]))
    						//fmt.Println(i,j,k)
						path1[i][j] = append(path1[i][j], strconv.Itoa(iroutetime[i][k]))
					}
				}
			}
			//fmt.Print("\n")
		}
		//fmt.Print("\n")
	}
	csvFile, err = os.Create("routetime.csv")
        if err != nil {
                log.Fatalf("failed creating file: %s", err)
        }
        csvwriter = csv.NewWriter(csvFile)


	var pathstring1 string
        var IDs0[n+n+2][] string
	//var pathstring1 [n+n+2][100] string
	for i:= 1; i <= n+n; i++ {
		for j:= 0; j < act; j++ {
			pathstring1 = strings.Join(path1[i][j]," ")
    			IDs0[i] = append(IDs0[i], pathstring1)
			//fmt.Println(path[i][j])

		}

			//path[i][j] = strings.Replace(pathstring, ",", "|", act)
	}
	for o := 1; o <= n+n; o++ {
                _ = csvwriter.Write(IDs0[o])
        }


	csvwriter.Flush()
	csvFile.Close()

	// Source location based Privacy Tables write in CSV - Dummy include
	csvFile, err = os.Create("d-sourceprivacy.csv")
        if err != nil {
                log.Fatalf("failed creating file: %s", err)
        }
        csvwriter = csv.NewWriter(csvFile)
        var ID1[n+1][] string
        //var pathstring1 [n+n+2][100] string
        for i:= 1; i <= n; i++ {
                for j:= 0; j < act; j++ {
			if ssprivacy[i][j] == 0.0 {
				ssprivacy[i][j] = ssprivacy[i][j-1]
			}
			st := fmt.Sprintf("%f", ssprivacy[i][j])
                        ID1[i] = append(ID1[i], st)
                        //fmt.Println(path[i][j])

                }

                        //path[i][j] = strings.Replace(pathstring, ",", "|", act)
        }
        for o := 1; o <= n; o++ {
                _ = csvwriter.Write(ID1[o])
        }


        csvwriter.Flush()
        csvFile.Close()

	// Source location based Privacy Tables write in CSV - Dummy, probability, labelling include
	csvFile, err = os.Create("pd-sourceprivacy.csv")
        if err != nil {
                log.Fatalf("failed creating file: %s", err)
        }
        csvwriter = csv.NewWriter(csvFile)
        var ID21[n+1][] string
        //var pathstring1 [n+n+2][100] string
        for i:= 1; i <= n; i++ {
                for j:= 0; j < act; j++ {
			if plsprivacy[i][j] == 0.0 {
				plsprivacy[i][j] = plsprivacy[i][j-1]
			}
			st := fmt.Sprintf("%f", plsprivacy[i][j])
                        ID21[i] = append(ID21[i], st)
                        //fmt.Println(path[i][j])

                }

                        //path[i][j] = strings.Replace(pathstring, ",", "|", act)
        }
        for o := 1; o <= n; o++ {
                _ = csvwriter.Write(ID21[o])
        }


        csvwriter.Flush()
        csvFile.Close()


	// Source location based Privacy Tables write in CSV - Dummy and source labelling include
	csvFile, err = os.Create("dlabel-sourceprivacy.csv")
        if err != nil {
                log.Fatalf("failed creating file: %s", err)
        }
        csvwriter = csv.NewWriter(csvFile)
        var IDs1[n+1][] string
        //var pathstring1 [n+n+2][100] string
        for i:= 1; i <= n; i++ {
                for j:= 0; j < act; j++ {
			if ldsprivacy[i][j] == 0.0 {
				ldsprivacy[i][j] = ldsprivacy[i][j-1]
			}
			st := fmt.Sprintf("%f", ldsprivacy[i][j])
                        IDs1[i] = append(IDs1[i], st)
                        //fmt.Println(path[i][j])

                }

                        //path[i][j] = strings.Replace(pathstring, ",", "|", act)
        }
        for o := 1; o <= n; o++ {
                _ = csvwriter.Write(IDs1[o])
        }


        csvwriter.Flush()
        csvFile.Close()


	 // Source location based Privacy Tables write in CSV - Source labelling include
        csvFile, err = os.Create("label-sourceprivacy.csv")
        if err != nil {
                log.Fatalf("failed creating file: %s", err)
        }
        csvwriter = csv.NewWriter(csvFile)
        var IDs2[n+1][] string
        //var pathstring1 [n+n+2][100] string
        for i:= 1; i <= n; i++ {
                for j:= 0; j < act; j++ {
                        if lsprivacy[i][j] == 0.0 {
                                lsprivacy[i][j] = lsprivacy[i][j-1]
                        }
                        st := fmt.Sprintf("%f", lsprivacy[i][j])
                        IDs2[i] = append(IDs2[i], st)
                        //fmt.Println(path[i][j])

                }

                        //path[i][j] = strings.Replace(pathstring, ",", "|", act)
        }
        for o := 1; o <= n; o++ {
                _ = csvwriter.Write(IDs2[o])
        }


        csvwriter.Flush()
        csvFile.Close()


	// Destination location based Privacy Tables write in CSV - Dummy include
        csvFile, err = os.Create("d-destinationprivacy.csv")
        if err != nil {
                log.Fatalf("failed creating file: %s", err)
        }
        csvwriter = csv.NewWriter(csvFile)
        var ID2[n+1][] string
        //var pathstring1 [n+n+2][100] string
        for i:= 1; i <= n; i++ {
                for j:= 0; j < act; j++ {
			if ddprivacy[i][j] == 0.0 {
				ddprivacy[i][j] = ddprivacy[i][j-1]
			}
			st := fmt.Sprintf("%f", ddprivacy[i][j])
                        ID2[i] = append(ID2[i], st)
                        //fmt.Println(path[i][j])

                }

                        //path[i][j] = strings.Replace(pathstring, ",", "|", act)
        }
        for o := 1; o <= n; o++ {
                _ = csvwriter.Write(ID2[o])
        }


        csvwriter.Flush()
        csvFile.Close()

	// Present location based Privacy Tables write in CSV - Dummy include
        csvFile, err = os.Create("d-presentprivacy.csv")
        if err != nil {
                log.Fatalf("failed creating file: %s", err)
        }
        csvwriter = csv.NewWriter(csvFile)
        var ID3[n+1][] string
        //var pathstring1 [n+n+2][100] string
        for i:= 1; i <= n; i++ {
                for j:= 0; j < act; j++ {
			if pdprivacy[i][j] == 0.0 {
				pdprivacy[i][j] = pdprivacy[i][j-1]
			}
			st := fmt.Sprintf("%f", pdprivacy[i][j])
                        ID3[i] = append(ID3[i], st)
                        //fmt.Println(path[i][j])

                }

                        //path[i][j] = strings.Replace(pathstring, ",", "|", act)
        }
        for o := 1; o <= n; o++ {
                _ = csvwriter.Write(ID3[o])
        }


        csvwriter.Flush()
        csvFile.Close()

	// Source location based Privacy Tables write in CSV 
	csvFile, err = os.Create("sourceprivacy.csv")
        if err != nil {
                log.Fatalf("failed creating file: %s", err)
        }
        csvwriter = csv.NewWriter(csvFile)
        var ID4[n+1][] string
        //var pathstring1 [n+n+2][100] string
        for i:= 1; i <= n; i++ {
                for j:= 0; j < act; j++ {
			if sprivacy[i][j] == 0.0 {
				sprivacy[i][j] = sprivacy[i][j-1]
			}
			st := fmt.Sprintf("%f", sprivacy[i][j])
                        ID4[i] = append(ID4[i], st)
                        //fmt.Println(path[i][j])

                }

                        //path[i][j] = strings.Replace(pathstring, ",", "|", act)
        }
        for o := 1; o <= n; o++ {
                _ = csvwriter.Write(ID4[o])
        }


        csvwriter.Flush()
        csvFile.Close()

	// Destination location based Privacy Tables write in CSV
        csvFile, err = os.Create("destinationprivacy.csv")
        if err != nil {
                log.Fatalf("failed creating file: %s", err)
        }
        csvwriter = csv.NewWriter(csvFile)
        var ID5[n+1][] string
        //var pathstring1 [n+n+2][100] string
        for i:= 1; i <= n; i++ {
                for j:= 0; j < act; j++ {
			if dprivacy[i][j] == 0.0 {
				dprivacy[i][j] = dprivacy[i][j-1]
			}
			st := fmt.Sprintf("%f", dprivacy[i][j])
                        ID5[i] = append(ID5[i], st)
                        //fmt.Println(path[i][j])

                }

                        //path[i][j] = strings.Replace(pathstring, ",", "|", act)
        }
        for o := 1; o <= n; o++ {
                _ = csvwriter.Write(ID5[o])
        }


        csvwriter.Flush()
        csvFile.Close()

	// Present location based Privacy Tables write in CSV
        csvFile, err = os.Create("presentprivacy.csv")
        if err != nil {
                log.Fatalf("failed creating file: %s", err)
        }
        csvwriter = csv.NewWriter(csvFile)
        var ID6[n+1][]string
        //var pathstring1 [n+n+2][100] string
        for i:= 1; i <= n; i++ {
                for j:= 0; j < act; j++ {
			if pprivacy[i][j] == 0.0 {
				pprivacy[i][j] = pprivacy[i][j-1]
			}
			st := fmt.Sprintf("%f", pprivacy[i][j])
                        ID6[i] = append(ID6[i], st)
                        //fmt.Println(path[i][j])

                }

                        //path[i][j] = strings.Replace(pathstring, ",", "|", act)
        }
        for o := 1; o <= n; o++ {
                _ = csvwriter.Write(ID6[o])
        }


        csvwriter.Flush()
        csvFile.Close()

	fmt.Println("######## Final Result: Start and End Location Count ##########")
        for j := 1; j < l+sl+sl-2; j++ {
                fmt.Println("Location ",j,":",sodes[j])
        }
	
	fmt.Println("######## Final Result: Start and End Location Count with Dummy##########")
        for j := 1; j < l+sl+sl-2; j++ {
                fmt.Println("Location ",j,":",dsodes[j])
        }
	
	fmt.Println("######## Final Result: Start and End Location Count with Dummy - probability##########")
        for j := 1; j < l+sl+sl-2; j++ {
                fmt.Println("Location ",j,":",pdsodes[j])
        }

	fmt.Println("######## Source Location to Destination Matrix - with dummy and source labeling ##########")
        for j := 1; j < l+sl+sl-2; j++ {
        	for k := 1; k < l+sl+sl-2; k++ {
                	fmt.Println("Location ",j,":",ldsmatrix[j][k])
		}
        }
	
	fmt.Println("######## Source Location to Destination Matrix - with source labeling ##########")
        for j := 1; j < l+sl+sl-2; j++ {
        	for k := 1; k < l+sl+sl-2; k++ {
                	fmt.Println("Location ",j,":",lsmatrix[j][k])
		}
        }
	
	fmt.Println("######## Source Location to Destination Matrix - with source labeling, dummy and probability ##########")
        for j := 1; j < l+sl+sl-2; j++ {
        	for k := 1; k < l+sl+sl-2; k++ {
                	fmt.Println("Location ",j,":",pldsmatrix[j][k])
		}
        }
	for i:= 1; i <= n+n; i++ {
                fmt.Println(iroute[i])
	}
	fmt.Println("########## Considering the Dummy - Trajectory Privacy Loss #########")
	for i:= 1; i <= n; i++ {
		privacytrajectory(i, routevisit)
	}
	// Write into CSV file wight for graph with dummy
	wcsvFile, err := os.Create("weight.csv")
        if err != nil {
                log.Fatalf("failed creating file: %s", err)
        }
        wcsvwriter := csv.NewWriter(wcsvFile)
        var WID[(n+sl+l)*(n+sl+l)][]string
        //var st1,st2,st3 string
        //var pathstring1 [n+n+2][100] string
        for i:= 1; i < idtrack; i++ {
                WID[i] = append(WID[i], strconv.Itoa(routeid[i][0]))
                WID[i] = append(WID[i], strconv.Itoa(routeid[i][1]))
                WID[i] = append(WID[i], strconv.Itoa(routevisit[i]))
                        //fmt.Println(path[i][j])
        }

                        //path[i][j] = strings.Replace(pathstring, ",", "|", act)
        for o := 1; o < idtrack; o++ {
                _ = wcsvwriter.Write(WID[o])
        }


        wcsvwriter.Flush()
        csvFile.Close()


	fmt.Println("########## Considering without Dummy - Trajectory Privacy Loss #########")
	for i:= 1; i <= n; i++ {
		privacytrajectory(i, ndroutevisit)
	}

	// Write into CSV file dummylesswight for graph without dummy
	dwcsvFile, err := os.Create("dummylessweight.csv")
        if err != nil {
                log.Fatalf("failed creating file: %s", err)
        }
        dwcsvwriter := csv.NewWriter(dwcsvFile)
        var NDWID[(n+sl+l)*(n+sl+l)][]string
        //var st1,st2,st3 string
        //var pathstring1 [n+n+2][100] string
        for i:= 1; i < idtrack; i++ {
                NDWID[i] = append(NDWID[i], strconv.Itoa(routeid[i][0]))
                NDWID[i] = append(NDWID[i], strconv.Itoa(routeid[i][1]))
                NDWID[i] = append(NDWID[i], strconv.Itoa(ndroutevisit[i]))
                        //fmt.Println(path[i][j])
        }

                        //path[i][j] = strings.Replace(pathstring, ",", "|", act)
        for o := 1; o < idtrack; o++ {
                _ = dwcsvwriter.Write(NDWID[o])
        }


        dwcsvwriter.Flush()
        csvFile.Close()



	//for j := 1; j < idtrack; j++ {
        //      fmt.Println("route visit of",j,": ", routevisit[j],"--",ndroutevisit[j],"---",routeid[j])
        //}


}
